<?php

namespace Database\Seeders;

use App\Models\Href;
use Illuminate\Database\Seeder;

class HrefSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $urls = [
            (object)[
                'page_name' => 'Home',
                'href' => '/',
            ],
            (object)[
                'page_name' => 'About',
                'href' => '/about-us',
            ],
            (object)[
                'page_name' => 'Testimonial',
                'href' => '/testimonial',
            ],
            (object)[
                'page_name' => 'Places',
                'href' => '/places',
            ],
            (object)[
                'page_name' => 'Hotel',
                'href' => '/hotel',
            ],
            (object)[
                'page_name' => 'Blogs',
                'href' => '/blog',
            ],
            (object)[
                'page_name' => 'Teams',
                'href' => '/team',
            ],
            (object)[
                'page_name' => 'Faq',
                'href' => '/faq',
            ],
            (object)[
                'page_name' => 'Contacts',
                'href' => '/contact',
            ],
            (object)[
                'page_name' => 'Login',
                'href' => '/login',
            ],
        ];

        foreach ($urls as $url){
            Href::create([
                'page_name' =>  $url->page_name,
                'href' =>  $url->href,
            ]);
        }

    }
}
