const PAYPAL_PAYMENT = $("#paypal_script").data("paypal-payment");
const PAYPAL_SUCCESS_URL = $("#paypal_script").data("success-url");
const PAYPAL_DATA = {
    BOOKING_ID: $("#paypal_script").data("booking-id"),
    REQUEST_TYPE: $("#paypal_script").data("request-type"),
    USER_ID: $("#paypal_script").data("user-id"),
};

async function loadPayPalButton() {
    if (window.selectedPaymentMethod == PAYPAL_PAYMENT) {
        return;
    }

    $("#stripe_container").hide();
    $("#method_container1 .loading").show();
    $("#paypal_container").html("");
    $("#method1").attr("disabled", true);
    await paypal
        .Buttons({
            style: {
                size: "small",
                color: "gold",
                shape: "rect",
                label: "pay",
            },

            createOrder: function (data, actions) {
                return actions.order.create({
                    purchase_units: [
                        {
                            amount: {
                                value: PAYABLE_AMOUNT,
                            },
                        },
                    ],
                });
            },

            onApprove: function (data, actions) {
                return actions.order.capture().then(function (orderData) {
                    var transaction =
                        orderData.purchase_units[0].payments.captures[0];
                    if (transaction.status == "COMPLETED") {
                        $("#method_container1 .loading").show();
                        $("#paypal_container").hide();
                        axios
                            .post(PAYPAL_SUCCESS_URL, {
                                transactionId: transaction.id,
                                bookingId: PAYPAL_DATA.BOOKING_ID,
                                type: PAYPAL_DATA.REQUEST_TYPE,
                                amount: PAYPAL_DATA.PAYABLE_AMOUNT,
                            })
                            .then(function (response) {
                                window.paymentCompleted = true;
                                swal(
                                    "Success!",
                                    "Your payment has been processed successfully",
                                    "success"
                                );
                                if (response.data.status == "success") {
                                    $("#inside-checkout")
                                        .html(`<div class="alert alert-success mt-5">
                                <strong>Success!</strong> Your payment has been processed successfully.
                                <div>${response.data.message}</div>
                            </div>`);
                                    $(".method_container").html(
                                        `<div class="alert alert-success text-center">Payment is successfully completed</div>`
                                    );
                                    $("#method_container1 .loading").hide();
                                } else {
                                    $("#inside-checkout")
                                        .html(`<div class="alert alert-warning mt-5">
                                <strong>Notice!</strong> Your payment has been processed successfully.
                                <div>${response.data.message}</div>
                            </div>`);
                                    $(".method_container").html(
                                        `<div class="alert alert-success text-center">Payment is successfully completed</div>`
                                    );
                                    $("#method_container1 .loading").hide();
                                }
                            });
                    } else {
                        $("#paypal_container").html(
                            '<div class="alert alert-danger text-center">Transaction failed!</div>'
                        );
                    }
                });
            },
        })
        .render("#paypal_container");
    $("#method_container1 .loading").hide();
    $("#paypal_container").show();
    $("#method1").attr("disabled", false);
    window.selectedPaymentMethod = PAYPAL_PAYMENT;
}
