<script type="text/javascript">
    (function($) {
        "use strict";
        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('admin.booking.hotel.index') }}",
                data: function(d) {
                    d.hotel_id = $('#hotel_list').val(),
                    d.search = $('input[type="search"]').val()
                }
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'hotel',
                    name: 'hotel',
                },
                {
                    data: 'customer',
                    name: 'customer',
                },
                {
                    data: 'reservation',
                    name: 'reservation',
                },
                {
                    data: 'status',
                    name: 'status',
                },
                {
                    data: 'action',
                    name: 'action',
                }
            ]
        });

        $(document.body).on('change','#hotel_list',function(){
          table.draw();
        });

        $('.single_select').select2({
            placeholder: "Select a Hotel"
        });

    })(jQuery);
</script>
