@extends('backend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
<div id="wrapper-content">
    <div class="row">
        <div class="col">
            <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                <span class="breadcrumb-item active">{{ __($title) }}</span>
                <span class="breadcrumb-info" id="time"></span>
            </nav>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card card-dark bg-dark">
                <div class="card-header d-block">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <h6 class="card-title lh-35">{{ __($title) }}</h6>
                        </div>
                        <div class="col-md-6 col-sm-12 text-right">
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <h4>{{ __('Package Information') }}</h4>
                    <p class="mb-1">
                        <b>{{ __('Name: ') }}</b>{{ $package_booking->package->title }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Group Person: ') }}</b>{{ $package_booking->packageSubPrice->group_size }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Group Price: ') }}</b>{{ currencyFormat($package_booking->amount) }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Discount: ') }}</b>{{ currencyFormat($package_booking->discount_amount) }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Net Price: ') }}</b>{{ currencyFormat($package_booking->net_amount) }}
                    </p>
                    <hr>
                    <h4>{{ __('Customar Information') }}</h4>
                    <p class="mb-1">
                        <b>{{ __('First Name: ') }}</b>{{ $package_booking->first_name }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Last Name: ') }}</b>{{ $package_booking->last_name }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Email: ') }}</b>{{ $package_booking->email }}
                    </p>
                    <hr>
                    <h4>{{ __('Arrival Information') }}</h4>
                    <p class="mb-1">
                        <b>{{ __('In: ') }}</b>{{ date('d F, Y H:i A', strtotime($package_booking->arrival_date_time)) }}
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('page-script')
@include('backend.pages.booking.internal-assets.js.delete-warning')
@include('backend.pages.booking.internal-assets.js.package-datatable')
<script src="{{ asset('backend/assets/js/service-activation.js') }}"></script>
@endsection