@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/daterangepicker.css') }}">
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ $title }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h5>{{ $title }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <form
                            action="{{ $discount ? route('admin.discounts.update', $discount->id) : route('admin.discounts.store') }}"
                            method="POST" class="wma-form" enctype="multipart/form-data">
                            @csrf
                            @if ($discount)
                                @method('PUT')
                            @endif
                            <p class="mb-1"><label for="title"
                                    class="card-title font-weight-bold">{{ __('Title :') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="title" class="form-control" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Title') }}"
                                    value="{{ $discount ? $discount->title : old('title') }}">
                                @error('departure_date')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold">{{ __('Package :') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="package[]" multiple="multiple" class="form-control"
                                    aria-label="Large" aria-describedby="inputGroup-sizing-sm" id="package">
                                    <option value="">{{ __('Select') }}</option>
                                    @foreach ($package as $pkg)
                                        <option
                                            {{ $discount && (count($discount_package) && in_array($pkg->id, $discount_package)) ? 'selected' : '' }}
                                            value="{{ $pkg->id }}">{{ $pkg->title }}</option>
                                    @endforeach
                                </select>
                                @error('discount_type')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold">{{ __('Hotel :') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="hotel[]" class="form-control" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" id="hotel" multiple="multiple">
                                    <option value="">{{ __('Select') }}</option>
                                    @foreach ($hotel as $htl)
                                        <option
                                            {{ $discount && (count($discount_hotel) && in_array($htl->id, $discount_hotel)) ? 'selected' : '' }}
                                            value="{{ $htl->id }}">{{ $htl->hotel_name }}</option>
                                    @endforeach
                                </select>
                                @error('discount_type')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold">{{ __('Discount Type :') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="discount_type" class="form-control" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" required>
                                    <option value="">{{ __('Select') }}</option>
                                    @foreach (discountType() as $key => $dt)
                                        <option {{ $discount && $discount->discount_type == $key ? 'selected' : '' }}
                                            value="{{ $key }}">{{ $dt }}</option>
                                    @endforeach
                                </select>
                                @error('discount_type')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="ammount"
                                    class="card-title font-weight-bold">{{ __('Amount:') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="number" step="any" min="0" name="amount" class="form-control"
                                    aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                    placeholder="{{ __('Amount') }}"
                                    value="{{ $discount ? $discount->amount : old('amount') }}">
                                @error('amount')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="details"
                                    class="card-title font-weight-bold">{{ __('Detail:') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="details" class="form-control" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Details') }}"
                                    value="{{ $discount ? $discount->details : old('details') }}">
                                @error('details')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>

                            <p class="mb-1"><label for="start_date"
                                    class="card-title font-weight-bold">{{ __('Start End Date:') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" id="datetimepicker" name="start_end_date" class="form-control"
                                    value="{{ $discount ? $start_end_date : old('start_end_date') }}" />
                                @error('start_end_date')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-12">
                                <p class="h6 mb-3">
                                    {{ __('Images') }}:<code>{{ __('(Only jpeg, png, jpg and gif file is
                                    acceptable)') }}</code>
                                </p>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="">
                                            <div class="thumbnail-image" id="thumbnail_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                    </div>
                                    @if ($discount)
                                        <div class="col-md-6 text-center">
                                            {!! imageShow($discount->images, 'Image', 'img-thumbnail', 'width="35%" height="200') !!}
                                        </div>
                                    @endif
                                </div>
                                @error('images.0')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit">{{ __('Submit') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    <script src="{{ asset('backend/assets/js/discount_sub.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/moment.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/daterangepicker.js') }}"></script>
    @include('backend.pages.blogs.internal-assets.js.delete-warning')
    @include('backend.layouts.message')
    @include('backend.pages.discount.script')
@endsection
