@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                        <a class="breadcrumb-item text-white"
                           href="{{route('admin.dashboard')}}">{{__('Home')}}</a>
                        <span class="breadcrumb-item active">{{__($title)}}</span>
                        <span class="breadcrumb-info" id="time"></span>
                    </nav>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card card-dark bg-dark">
                        <div class="card-header d-block">
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <h6 class="card-title">{{__($title)}}</h6>
                                </div>
                                <div class="col-md-6 col-sm-12 text-right">

                                </div>
                            </div>
                        </div>
                        <div class="card-body ">
                            <div class="table-responsive style-scroll">
                            <table id="slider" class="table bapric_table table-striped table-bordered miw-500" cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th width="15%">{{__('Serial')}}</th>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Phone') }}</th>
                                    <th>{{ __('Email') }}</th>
                                    <th>{{ __('Transaction Type') }}</th>
                                    <th>{{ __('Transaction number') }}</th>
                                    <th>{{ __('Page Type') }}</th>
                                    <th>{{ __('Page Type ID') }}</th>
                                    <th>{{ __('Amount') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($donates as $donate)
                                    <tr>
                                        <th>{{ $loop->index+1 }}</th>
                                        <td>{{ $donate->name }}</td>
                                        <td>{{ $donate->phone }}</td>
                                        <td>{{ $donate->email }}</td>
                                        <td>{{ $donate->page_type }}</td>
                                        <td>{{ $donate->page_type_id }}</td>
                                        <td>{{ $donate->payment_method }}</td>
                                        <td>{{ $donate->transaction_number }}</td>
                                        <td>{{ $donate->amount }}</td>
                                        <td>{{$donate->status == 1? "Unread" : "Read"}}</td>
                                        <td>
                                            <div class="d-flex">
                                                <a href="{{ route('admin.donate.view',$donate->id) }}">
                                                    <button type="button" class="btn btn-sm btn btn-success m-1 blogCategoryEditBtn" data-id="{{ $donate->id }}">{{ __('View') }}</button>
                                                </a>
                                                <a href="javascript:void(0)" title="{{__('Delete')}}" class="sliderDestroyBtn">
                                                    <button type="button" class="btn btn-sm btn btn-danger m-1">{{__('Delete')}}</button>
                                                    <form action="{{ route('admin.donate.destroy', $donate->id) }}" method="post" class="deleteForm">
                                                        @csrf
                                                        @method('delete')
                                                        <input type="hidden" name="_method" value="delete">
                                                    </form>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    @include('backend.pages.contacts.internal-assets.js.delete-warning')
    @include('backend.layouts.message')
@endsection
