@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{__('Home')}}</a>
                    <a class="breadcrumb-item text-white"
                       href="{{ route('admin.gallery.index') }}">{{__('Gallery')}}</a>
                    <span class="breadcrumb-item active">{{__($title)}}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title">{{__($title)}}</h6>
                    </div>
                    <form
                        action="{{ $gallery? route('admin.gallery.update',$gallery->id) : route('admin.gallery.store') }}"
                        method="POST" enctype="multipart/form-data">
                        @csrf
                        @if($gallery)
                            @method('PATCH')
                        @endif
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-6 pr-2">
                                    <p class="mb-1 font-weight-bold">{{__('Title :')}} </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="title" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="{{__('Image name')}}"
                                               value="{{ $gallery?$gallery->title:old('title') }}">
                                        <br>
                                        @if ($errors->has('title'))
                                            <span class="text-danger">{{ $errors->first('title') }}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6 pl-3">
                                    <div class=" ">
                                        <p class="mb-2 font-weight-bold">{{__('Image : ')}}
                                            <code>{{('Acceptable image size 370 x 336 pixel')}}</code></p>
                                        <div class="mb-3">
                                            <div class="partner_bg_image" id="partner_bg_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                    </div>
                                    @if($gallery)
                                        <div class="pr-2 ">
                                            <p class="mb-2 font-weight-bold ">{{__('Old Image :')}} </p>
                                            {!! imageShow($gallery->image, 'Image', 'img-thumbnail bg-secondary', 'width="200"', 'App\Models\Gallery', $gallery->id, 'image') !!}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit">{{__('Submit form')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    @include('backend.pages.gallery.internal-assets.js.gallery-page-scripts')
    @include('backend.layouts.message')
    @include('backend.pages.delete-warning')
@endsection
