@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ $title }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35">{{ $title }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <form
                            action="{{ $hotels ? route('admin.hotel.image.update', $hotels->id) : route('admin.hotel.image.store') }}"
                            method="POST" enctype="multipart/form-data" class="wma-form">
                            @csrf
                            @if ($hotels)
                                @method('PATCH')
                            @endif
                            <div class="form-group">
                                <p class="mb-1"><label for="name"
                                        class="card-title font-weight-bold">{{ __('Hotel Name:') }}</label></p>
                                <div class="input-group input-group-lg mb-3">
                                    <select class="form-control form-control-lg single_select" name="hotel_id">
                                        <option value="">{{ __('Select one') }}</option>

                                        @foreach ($hotelNames as $hotelName)
                                            <option value="{{ $hotelName->id }}"
                                                {{ $hotels ? ($hotels->hotel_id == $hotelName->id ? 'selected' : '') : '' }}>
                                                {{ $hotelName->hotel_name }}</option>
                                        @endforeach
                                    </select>
                                    <br>
                                    @error('hotel_id')
                                        <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <p class="h6 mb-3">
                                {{ __('Image') }}:<code>{{ __('(Only jpeg, png, jpg and gif file is
                                acceptable)') }}</code>
                            </p>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <div class="service_icon" id="service_icon" data-number="5"
                                            data-input="hotel_image">
                                            <div class="input-images"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 text-center">
                                    @if ($hotels)
                                        <img src="{{ asset('upload/hotel-image/' . $hotels->hotel_image) }}"
                                            class="img-thumbnail " width="35%" height="200">
                                    @endif
                                </div>
                                @error('hotel_image')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit">{{ __('Submit') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    @include('backend.pages.hotel-image.internal-assets.js.page-scripts')
    @include('backend.layouts.message')
@endsection
