@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <a class="breadcrumb-item text-white" href="{{ route('admin.hotel.index') }}">{{ __('Hotel') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title">{{ __($title) }}</h6>
                    </div>
                    <form action="{{ $item ? route('admin.facility.update', $item->id) : route('admin.facility.store') }}"
                        method="post" enctype="multipart/form-data">
                        @csrf
                        @if ($item)
                            @method('PATCH')
                        @endif
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="">{{ __('Title') }}</label>
                                        <input type="text" name="name" value="{{ $item ? $item->name : old('name') }}" class="form-control">
                                        @error('name')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-2 font-weight-bold">{{ __('Main Image :') }}
                                            <code>{{ __('(Only jpeg, png, jpg and gif file is acceptable)') }}</code>
                                        </p>
                                        <div class="mb-3">
                                            <div class="facility_icon" id="facility_icon">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        @error('icon')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    @if ($item)
                                        <div class="pl-3 pr-2 ">
                                            <p class="mb-2 font-weight-bold ">{{ __('Facility Icon :') }} </p>
                                            {!! imageShow($item->icon, 'Facility Icon', 'img-thumbnail bg-secondary', 'width="200" height="100"', 'App\Models\Facility', $item->id, 'icon') !!}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-sm-4">
                                    <p class="mb-2 font-weight-bold ">{{ __('Status') }} </p>
                                    <label class="switch">
                                        <input type="checkbox" name="status"
                                            {{ $item && $item->parking_info == ACTIVE_STATUS ? 'checked' : '' }}>
                                        <span class="slider round"></span>
                                    </label>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <div class="wizard-action">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit">{{ __('Submit & Next') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    @include('backend.pages.hotel.facility.internal-scripts.page-scripts')
    @include('backend.layouts.message')
    @include('backend.pages.delete-warning')
@endsection

