@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <a class="breadcrumb-item text-white" href="{{ route('admin.hotel.index') }}">{{ __('Hotel') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title">{{ __($title) }}</h6>
                    </div>
                    <form action="{{ $hotel ? route('admin.hotel.update', $hotel->id) : route('admin.hotel.store') }}"
                        method="post" enctype="multipart/form-data">
                        @csrf
                        @if ($hotel)
                            @method('PATCH')
                        @endif
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Country Name :') }} </p>
                                        <select class="form-control single_select" name="country" id="country_select">
                                            <option value="">{{ __('Select') }}</option>
                                            @foreach ($countries as $id)
                                                <option
                                                    {{ $hotel && $hotel->country == $id->id ? 'selected' : '' }}
                                                    value="{{ $id->id }}">{{ $id->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('City Name :') }} </p>
                                        <select class="w-100 form-control single_select" name="city" id="cities_id">
                                            <option value="">{{ __('Select one') }}</option>
                                            @if (isset($hotel) && count($cities))
                                                @foreach ($cities as $city)
                                                    <option {{ $hotel->city == $city->id ? 'selected' : '' }}
                                                        value="{{ $city->id }}">{{ $city->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Hotel Address :') }} </p>
                                        <input type="text" name="hotel_location" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm"
                                            placeholder="{{ __('Hotel Location') }}"
                                            value="{{ $hotel ? $hotel->hotel_location : old('hotel_location') }}">
                                        @error('hotel_location')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Latitude :') }} </p>
                                        <input type="number" min="-90" max="90" step="any" name="latitude"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm"
                                            placeholder="{{ __('Hotel Location') }}"
                                            value="{{ $hotel ? $hotel->latitude : old('latitude') }}">

                                        @error('latitude')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Longitude :') }} </p>
                                        <input type="number" min="-180" max="180" step="any" name="longitude"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm"
                                            placeholder="{{ __('Hotel Location') }}"
                                            value="{{ $hotel ? $hotel->longitude : old('longitude') }}">

                                        @error('longitude')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Hotel Name :') }} </p>
                                        <input type="text" name="hotel_name" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Hotel Name') }}"
                                            value="{{ $hotel ? $hotel->hotel_name : old('hotel_name') }}">
                                        @error('hotel_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Email :') }} </p>
                                        <input type="email" name="email" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Hotel Email') }}"
                                            value="{{ $hotel ? $hotel->email : old('email') }}">
                                        @error('email')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Phone :') }} </p>
                                        <input type="tel" name="phone" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Phone') }}"
                                            value="{{ $hotel ? $hotel->phone : old('phone') }}">
                                        @error('phone')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Website:') }} </p>
                                        <input type="url" name="website" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Website') }}"
                                            value="{{ $hotel ? $hotel->website : old('website') }}">
                                        @error('website')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Description :') }} </p>
                                        <textarea class="form-control bapric_edittor" name="description"
                                            aria-label="With textarea" rows="5"
                                            placeholder="{{ __('Write description here...') }}">{!! clean($hotel ? $hotel->description : old('description')) !!}</textarea>
                                        @error('description')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Rules :') }} </p>
                                        <textarea class="form-control bapric_edittor" name="rules"
                                            aria-label="With textarea" rows="5"
                                            placeholder="{{ __('Write rules here...') }}">{!! clean($hotel ? $hotel->rules : old('rules')) !!}</textarea>
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Hotel to stay title :') }} </p>
                                        <input type="text" name="hotel_to_stay_title" class="form-control"
                                            aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                            placeholder="{{ __('Hotel Location') }}"
                                            value="{{ $hotel ? $hotel->hotel_to_stay_title : old('hotel_to_stay_title') }}">
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Breakfast Info:') }} <span
                                                class="text-success">{{ __('(Add cuisine with comma)') }}</span></p>
                                        <input type="text" name="breakfast_info" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm"
                                            placeholder="{{ __('Breakfast Info') }}"
                                            value="{{ $hotel ? $hotel->breakfast_info : old('breakfast_info') }}">

                                        @error('breakfast_info')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Lunch Info:') }} <span
                                                class="text-success">{{ __('(Add cuisine with comma)') }}</span></p>
                                        <input type="text" name="lunch_info" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="{{ __('Lunch Info') }}"
                                               value="{{ $hotel ? $hotel->lunch_info : old('lunch_info') }}">

                                        @error('lunch_info')
                                        <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Dinner Info:') }} <span
                                                class="text-success">{{ __('(Add cuisine with comma)') }}</span></p>
                                        <input type="text" name="dinner_info" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="{{ __('Dinner Info') }}"
                                               value="{{ $hotel ? $hotel->dinner_info : old('dinner_info') }}">

                                        @error('dinner_info')
                                        <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Hotel to stay Description :') }} </p>
                                        <textarea class="form-control bapric_edittor" name="hotel_to_stay_description"
                                            aria-label="With textarea" rows="5"
                                            placeholder="{{ __('Write description here...') }}">{!! clean($hotel ? $hotel->hotel_to_stay_description : old('hotel_to_stay_description')) !!}</textarea>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p class="mb-1">{{ __('Facility :') }}</p>
                                        <select class="form-control form-control-lg multi_select" name="facilities[]"
                                            multiple="multiple">
                                            @foreach ($facilities as $facility)
                                                <option
                                                    {{ $hotel && is_array($hotel_facilities) && in_array($facility->id, $hotel_facilities) ? 'selected' : '' }}
                                                    value="{{ $facility->id }}">{{ $facility->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('facilities')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-2 font-weight-bold">{{ __('Main Image :') }}
                                            <code>{{ __('(Only jpeg, png, jpg and gif file is acceptable)') }}</code>
                                        </p>
                                        <div class="mb-3">
                                            <div class="bg_image" id="bg_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        @error('bg_image')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    @if ($hotel)
                                        <div class="pl-3 pr-2 ">
                                            <p class="mb-2 font-weight-bold ">{{ __('Exists Main Image :') }} </p>
                                            {!! imageShow($hotel->hotel_primary_image, 'hotel image', 'img-thumbnail bg-secondary', 'width="200" height="100"',  'App\Models\Hotel', $hotel->id, 'hotel_primary_image') !!}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <p class="mb-2 font-weight-bold">{{ __('Feature Image :') }}
                                            <code>{{ __('(Only jpeg, png, jpg and gif file is acceptable)') }}</code>
                                        </p>
                                        <div class="mb-3">
                                            <div class="" id="feature_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        @error('feature_image')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    @if ($hotel)
                                        <div class="pl-3 pr-2 ">
                                            <p class="mb-2 font-weight-bold ">{{ __('Exists Feature Image :') }} </p>
                                            {!! imageShow(asset(UPLOAD_FOLDER_HOTELS . $hotel->feature_image), 'hotel feature image', 'img-thumbnail bg-secondary', 'width="200" height="100"',  'App\Models\Hotel', $hotel->id, 'feature_image') !!}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-sm-2">
                                    <p class="mb-2 font-weight-bold ">{{ __('Is Private Parking?') }} </p>
                                    <label class="switch">
                                        <input type="checkbox" name="parking_info"
                                            {{ $hotel && $hotel->parking_info == ACTIVE_STATUS ? 'checked' : '' }}>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="col-sm-2">
                                    <p class="mb-2 font-weight-bold ">{{ __('Status') }} </p>
                                    <label class="switch">
                                        <input type="checkbox" name="status"
                                            {{ $hotel && $hotel->status == ACTIVE_STATUS ? 'checked' : '' }}>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <div class="wizard-action">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit">{{ __('Submit & Next') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    @include('backend.pages.hotel.internal-assets.js.page-scripts')
    @include('backend.layouts.message')
    @include('backend.pages.delete-warning')
@endsection
