@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <a class="breadcrumb-item text-white" href="{{ route('admin.hotel.index') }}">{{ __('Hotel') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        @if (count($hotels))
                            <h6 class="card-title">{{ __('Hotel Accommodation') }}</h6>
                        @else
                            <h6 class="card-title">{{ __('Hotel Name:') }}
                                {{ isset($hotel) ? $hotel->hotel_name : '' }}</h6>
                        @endif
                    </div>
                    @if (count($list_hotel_accommodations))
                        @include('backend.pages.hotel.hotel-accommodation.list',['hotel_accommodations'=>$list_hotel_accommodations])
                    @endif
                    <form
                        action="{{ $hotel_accommodation ? route('admin.hotel-accommodation.update', $hotel_accommodation->id) : route('admin.hotel-accommodation.store') }}"
                        method="post" enctype="multipart/form-data">
                        @csrf
                        @if ($hotel_accommodation)
                            @method('PATCH')
                        @endif
                        <div class="card-body" id="accommodation_html">
                            @include('backend.pages.hotel.hotel-accommodation.include',
                            ['accommodation'=>$accommodations,'facilities'=>$facilities,'hotel'=>$hotel,'hotels'=>$hotels])
                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit">{{ __('Submit & Add More') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <form action="{{ route('admin.hotel-accommodation.image.destroy') }}" method="post" id="deleteForm"
        class="d-none">
    </form>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    @include('backend.pages.hotel.hotel-accommodation.internal-assets.js.page-scripts')
    @include('backend.pages.hotel.hotel-accommodation.internal-assets.js.delete-warning')
    @include('backend.layouts.message')
@endsection
