<table id="example" class="table bapric_table table-striped table-bordered miw-500" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th width="50">{{ __('SL') }}</th>
            <th>{{ __('Accommodation') }}</th>
            <th>{{ __('Room Size') }}</th>
            <th>{{ __('No. of Room') }}</th>
            <th>{{ __('No. of Guest') }}</th>
            <th>{{ __('Facilities') }}</th>
            <th>{{ __('Price') }}</th>
            <th>{{ __('Is Smoking') }}</th>
            <th width="10%">{{ __('Action') }}</th>
        </tr>
    </thead>
    <tbody id="data_html">
        @foreach ($hotel_accommodations as $item)
            <tr>
                <td>{{ $loop->index + 1 }}</td>
                <td>{{ $item->accommodation->name }}</td>
                <td>{{ $item->room_size . ' ' . __('sqr. mt.') }}</td>
                <td>{{ $item->no_of_room }}</td>
                <td>{{ $item->no_of_adult . __('Adult') }}
                    <br>
                    {{ $item->no_of_children . __('Children') }}
                </td>
                <td>{{ $item->facilities ? implodeFunc(', ', getFacilities($item->facilities)) : '' }}</td>
                <td>{{ currencyFormat($item->price) }}</td>
                <td>{{ statusActiveDeactive($item->is_smoking) }}</td>
                <td>
                    <div class="d-flex">
                        <a href="{{ route('admin.hotel-accommodation.edit', $item->id) }}">
                            <button type="button" class="btn btn-sm btn btn-success m-1 blogCategoryEditBtn"
                                data-id="{{ $item->id }}">{{ __('Edit') }}</button>
                        </a>
                        <a href="javascript:void(0)" title="{{ __('Delete') }}" class="deleteItem">
                            <button type="button" class="btn btn-sm btn btn-danger m-1">{{ __('Delete') }}</button>
                            <form action="{{ route('admin.hotel-accommodation.destroy', $item->id) }}" method="post"
                                class="deleteForm">
                                @csrf
                                @method('delete')
                                <input type="hidden" name="_method" value="delete">
                            </form>
                        </a>
                    </div>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
