@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35">{{ __($title) }}</h6>
                            </div>
                            <div class="col-md-6 col-sm-12 text-right">
                                <a href="{{ route('admin.package-departure.create') }}"
                                    class="btn btn-danger btn-sm rounded"><i class="material-icons">add</i></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="table bapric_table data-table table-striped table-bordered miw-500"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="10%">{{ __('SL') }}</th>
                                        <th>{{ __('Package') }}</th>
                                        <th>{{ __('Departure Date') }}</th>
                                        <th>{{ __('Total Place') }}</th>
                                        <th>{{ __('Available Place') }}</th>
                                        <th>{{ __('Booking Status') }}</th>
                                        <th width="10%">{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    @include('backend.pages.packages.departure.internal-assets.js.delete-warning')
    @include('backend.pages.packages.departure.internal-assets.js.datatable')
    <script src="{{ asset('backend/assets/js/tag-modal.js') }}"></script>
    <script src="{{ asset('backend/assets/js/blog-feature-popular.js') }}"></script>
@endsection
