@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
    <link href="{{asset('backend/assets/plugin/select2/select2.min.css')}}" rel="stylesheet"/>
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{route('admin.dashboard')}}">{{__('Home')}}</a>
                    <span class="breadcrumb-item active">{{$title}}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-4 col-sm-12">
                                <ul class="nav nav-tabs border-0">
                                    <li class="nav-item">
                                      <a class="nav-link active" href="#">{{__('Package')}}</a>
                                    </li>
                                    <li class="nav-item">
                                      <a class="nav-link " href="#">{{__('Sub Price')}}</a>
                                    </li>
                                    <li class="nav-item">
                                      <a class="nav-link" href="#">{{__('Departure')}}</a>
                                    </li>
                                  </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <form
                            action="{{route('admin.packages.store')}}"
                            method="POST" enctype="multipart/form-data" class="wma-form">
                            @csrf
                            <p class="mb-1"><label for="name"
                                class="card-title font-weight-bold">{{__('Category :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="category"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" required>
                                    <option value="">{{ __('Select') }}</option>
                                    @foreach($cats as $cat)
                                        <option value="{{$cat->id}}">{{$cat->name}}</option>
                                    @endforeach
                                </select>
                                @error('category')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="name"
                                class="card-title font-weight-bold">{{__('Place :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="place"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" required>
                                        <option value="">{{ __('Select') }}</option>
                                    @foreach($places as $place)
                                        <option value="{{$place->id}}">{{$place->name}}</option>
                                    @endforeach
                                </select>
                                @error('category')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="name"
                                                   class="card-title font-weight-bold">{{__('Title :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="title" value="{{ old('title') }}"
                                       class="form-control" aria-label="Large"
                                       aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Title')}}" required>
                                @error('title')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="name"
                                                   class="card-title font-weight-bold">{{__('Sub Title :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="sub_title" value="{{ old('sub_title') }}"
                                       class="form-control" aria-label="Large"
                                       aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Sub Title')}}" required>
                                @error('sub_title')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="row">
                                <div class="col-md-2 col-12">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Day :')}}</label></p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="day" value="{{ old('day') }}"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Day')}}" required>
                                        @error('day')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-2 col-12">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Price :')}}</label></p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="number" name="price" value="{{ old('price') }}"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Price')}}" required>
                                        @error('price')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-2 col-12">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Group Size :')}}</label></p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="group_size" value="{{ old('group_size') }}"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Group Size')}}" required>
                                        @error('group_size')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Location :')}}</label></p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="tour_location" value="{{ old('tour_location') }}"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Location')}}" required>
                                        @error('tour_location')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Best Time To Go :')}}</label></p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="best_time_to_go" value="{{ old('best_time_to_go') }}"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Best Time To Go')}}" required>
                                        @error('best_time_to_go')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Tour Attractions :')}}</label></p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="tour_attractions" value="{{ old('tour_attractions') }}"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Tour Attractions')}}" required>
                                        @error('tour_attractions')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Tour Availability :')}}</label></p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="tour_availability" value="{{ old('tour_availability') }}"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Tour Availability')}}" required>
                                        @error('tour_availability')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Next Scheduled Tour :')}}</label></p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="next_scheduled_tour" value="{{ old('next_scheduled_tour') }}"
                                            class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Next Scheduled Tour')}}" required>
                                        @error('next_scheduled')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12">
                                        <div class="form-group">
                                            <label for="pageContent">
                                                <span class="d-block card-title mb-1 font-weight-bold">{{__('Description :')}} </span>
                                            </label>
                                            <textarea name="description" id="description" rows="5"
                                                    class="form-control bapric_edittor"
                                                    placeholder="{{__('Description')}}">{{ old('description') }}</textarea>
                                            @error('description')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                            @enderror
                                        </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="pageContent">
                                            <span class="d-block card-title mb-1 font-weight-bold">{{__('HighLight :')}} </span>
                                        </label>
                                        <textarea name="highlight" id="highlight" rows="5"
                                                class="form-control bapric_edittor"
                                                placeholder="{{__('HighLight')}}">{{ old('highlight') }}</textarea>
                                        @error('highlight')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="pageContent">
                                            <span class="d-block card-title mb-1 font-weight-bold">{{__('Itineraries :')}} </span>
                                        </label>
                                        <textarea name="itineraries" id="itineraries" rows="5"
                                                class="form-control bapric_edittor"
                                                placeholder="{{__('Itineraries')}}">{{ old('itineraries') }}</textarea>
                                        @error('itineraries')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="pageContent">
                                            <span class="d-block card-title mb-1 font-weight-bold">{{__('Important Notes :')}} </span>
                                        </label>
                                        <textarea name="note" id="note" rows="5"
                                                class="form-control bapric_edittor"
                                                placeholder="{{__('Important Notes')}}">{{ old('note') }}</textarea>
                                        @error('note')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <p class="mb-1"><label for="name"
                                                               class="card-title font-weight-bold">{{__('Inclusion :')}}</label></p>

                                        <textarea name="inclusion" id="note" rows="5"
                                                  class="form-control bapric_edittor"
                                                  placeholder="{{__('Inclusion')}}">{{ old('inclusion') }}</textarea>

                                        @error('inclusion')
                                        <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>


                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                    <p class="mb-1"><label for="name"
                                                    class="card-title font-weight-bold">{{__('Exclusion :')}}</label></p>

                                         <textarea name="exclusion" id="note" rows="5"
                                                   class="form-control bapric_edittor"
                                                   placeholder="{{__('Exclusion')}}">{{ old('exclusion') }}</textarea>
                                        @error('exclusion')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="h6 mb-3">{{ __('Tour Map Image ') }}:<code>{{__('(Only jpeg, png, jpg and gif file is
                                        acceptable)')}}</code></p>
                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <div class="">
                                                <div class="thumbnail-image" id="thumbnail_image">
                                                    <div class="input-images"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @error('bg_image.0')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <p class="h6 mb-3">{{ __('Package Image ') }}:<code>{{__('(Only jpeg, png, jpg and gif file is
                                        acceptable)')}}</code></p>
                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <div class="">
                                                <div class="thumbnail-image package-image" id="package_image">
                                                    <div class="input-images"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @error('package_image')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit">{{__('Next')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    <script src="{{ asset('backend/assets/js/package/package_image.js') }}"></script>
    @include('backend.pages.blogs.internal-assets.js.delete-warning')
    @include('backend.layouts.message')
@endsection
