<script type="text/javascript">
    (function($) {
        "use strict";
        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('admin.package-subprice.index') }}",
                data: function(d) {
                    d.package_id = $('#package_list').val(),
                    d.search = $('input[type="search"]').val()
                }
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'package',
                    name: 'package',
                },
                {
                    data: 'group_size',
                    name: 'group_size',
                },
                {
                    data: 'tour_price',
                    name: 'tour_price',
                },
                {
                    data: 'action',
                    name: 'action',
                }
            ]
        });

        $(document.body).on('change','#package_list',function(){
          table.draw();
        });

    })(jQuery);
</script>
