@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35">{{ __($title) }}</h6>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <select id="package_list" name="package_id" class="form-control single_select">
                                    <option value="">{{ __('Select Package') }}</option>
                                    @if (count($packages))
                                        @foreach ($packages as $package)
                                            <option {{ $package_id && $package_id == $package->id ? 'selected' : '' }}
                                                value="{{ $package->id }}">{{ $package->title }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="col-md-2 col-sm-12 text-right">
                                <a href="{{ route('admin.package-subprice.create') }}"
                                    class="btn btn-danger btn-sm rounded"><i
                                        class="material-icons">{{ __('add') }}</i></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="table bapric_table data-table table-striped table-bordered miw-500"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="10%">{{ __('SL') }}</th>
                                        <th>{{ __('Package') }}</th>
                                        <th>{{ __('Group Size') }}</th>
                                        <th>{{ __('Package Sub Price') }}</th>
                                        <th width="10%">{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
<script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    @include('backend.pages.packages.subprice.internal-assets.js.delete-warning')
    @include('backend.pages.packages.subprice.internal-assets.js.datatable')
    @include('backend.pages.packages.subprice.internal-assets.js.page-scripts')
    <script src="{{ asset('backend/assets/js/tag-modal.js') }}"></script>
    <script src="{{ asset('backend/assets/js/blog-feature-popular.js') }}"></script>
@endsection
