@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-light bg-dark text-center">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title">{{ __($title) }}</h6>
                    </div>
                    <form action="{{ route('admin.payment.update', $payment->id) }}" method="POST"
                          enctype="multipart/form-data">
                        <div class="card-body">
                            @csrf
                            <div class="mb-3">
                                <p class="mb-1">{{ __('Name') }}: </p>
                                <div class="input-group input-group-lg">
                                    <input type="text" name="name" class="form-control" aria-label="Large"
                                           aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Name') }}"
                                           value="{{ $payment ? ucfirst($payment->name) : '' }}">
                                </div>
                                @error('name')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            @if ($payment->method_type == PAYPAL_PAYMENT)
                                <div class="mb-3">
                                    <p class="mb-1">{{ __('Account No') }}: </p>
                                    <div class="input-group input-group-lg">
                                        <input type="text" name="account" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Account No') }}"
                                               value="{{ $payment ? $payment->account : '' }}">
                                    </div>
                                    @error('account')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <p class="mb-1">{{ __('Client ID') }}: </p>
                                    <div class="input-group input-group-lg">
                                        <input type="text" name="client_id" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Client ID') }}"
                                               value="{{ $payment ? $payment->client_id : '' }}">
                                    </div>
                                    @error('client_id')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            @elseif($payment->method_type == STRIPE_PAYMENT)
                                <div class="mb-3">
                                    <p class="mb-1">{{ __('API ID') }}: </p>
                                    <div class="input-group input-group-lg">
                                        <input type="text" name="api_id" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Api ID') }}"
                                               value="{{ $payment ? $payment->api_id : '' }}">
                                    </div>
                                    @error('api_id')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            @endif

                            <div class="mb-3">
                                <p class="mb-1">{{ __('Secret ID') }}: </p>
                                <div class="input-group input-group-lg">
                                    <input type="text" name="secret_key" class="form-control" aria-label="Large"
                                           aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Secret ID') }}"
                                           value="{{ $payment ? $payment->secret_key : '' }}">
                                </div>
                                @error('secret_key')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <p class="h6 mb-3">
                                    {{ __('Logo') }}:<code>{{ __('(Only jpeg, png, jpg and gif file is acceptable)') }}</code>
                                </p>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="">
                                            <div class="logo-image" id="feature_image">
                                                <div class="input-images"></div>
                                                <input type="file" name="logo" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 text-center">
                                        @if ($payment)
                                            <img src="{{ $payment->logo }}" class="img-thumbnail" width="35%" alt="{{__('Logo')}}">
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit">{{ __('Submit form') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('page-script')
    @include('backend.layouts.message')
    <script src="{{ asset('backend/assets/js/payment-method.js') }}"></script>
@endsection
