@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-light bg-dark text-center">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">

                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35">{{ __($title) }}</h6>
                            </div>
                            <div class="col-md-6 col-sm-12 text-right">
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="slider" class="bapric_table table-striped table-bordered miw-500 table"
                                   cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="5%">{{ __('SL') }}</th>
                                        <th>{{ __('Logo') }}</th>
                                        <th>{{ __('Payment') }}</th>
                                        <th>{{ __('Details') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Default') }}</th>
                                        <th width="10%">{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($payments as $payment)
                                        <tr>
                                            <td>{{ $loop->index + 1 }}</td>
                                            <td>
                                                <img src="{{ $payment->logo }}" alt="Logo" width="80">
                                            </td>
                                            <td>
                                                {{ __('Type: ') }}{{ $payment->method_type }} <br>
                                                {{ __('Name: ') }}{{ $payment->name }}
                                            </td>
                                            <td>
                                                @if ($payment->method_type == PAYPAL_PAYMENT)
                                                    <b>{{ __('Account:') }}</b> {{ $payment->account }} <br>
                                                    <b>{{ __('Client ID:') }}</b>
                                                    {{ Str::limit($payment->client_id, 25) }}<br>
                                                @elseif ($payment->method_type == STRIPE_PAYMENT)
                                                    <b>{{ __('Api Key:') }}</b>
                                                    {{ Str::limit($payment->api_id, 25) }}<br>
                                                @endif
                                                <b>{{ __('Secret Key:') }}</b>
                                                {{ Str::limit($payment->secret_key, 25) }}<br>
                                            </td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox"
                                                           {{ $payment->status == ACTIVE_STATUS ? 'checked' : '' }}
                                                           data-id="{{ $payment->id }}" data-status="{{ $payment->status }}" class="payment_status_change">
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                            <td>
                                                <label class="switch">
                                                    <input id="payment_default_change_{{ $payment->id }}" type="checkbox"
                                                           {{ $payment->is_default == ACTIVE_STATUS ? 'checked' : '' }}
                                                           data-id="{{ $payment->id }}" class="payment_default_change">
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a href="{{ route('admin.payment.edit', $payment->id) }}">
                                                        <button type="button"
                                                                class="btn btn-sm btn btn-success blogCategoryEditBtn m-1"
                                                                data-id="{{ $payment->id }}">{{ __('Edit') }}</button>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    @include('backend.pages.payment.scripts.delete-warning')
    @include('backend.pages.payment.scripts.payment-method-script')
    <script src="{{ asset('backend/assets/js/service-activation.js') }}"></script>
@endsection
