<script>
    (function($) {
        "use strict";

        $('.logo-image').imageUploader({
            imagesInputName: 'logo',
            maxFiles: 1,
        });


        // Author code here
        $(document.body).on('click', '.payment_status_change', function() {
            var id = $(this).data('id');
            var status = $(this).data('status');
            var token = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                type: 'POST',
                context: this,
                url: '{{ route('admin.payment.status.update') }}',
                data: {
                    id: id,
                    _token: token,
                    status: status
                },
                success: function(data) {
                    // do nothing;
                    if (data.status) {
                        toastr.success(data.msg);
                        $(this).data('status', data.update_status);
                    } else {
                        toastr.error(data.msg);
                    }
                }
            });
        });

        $(document.body).on('click', '.payment_default_change', function() {
            var id = $(this).data('id');
            var token = $('meta[name="csrf-token"]').attr('content');

            $.ajax({
                type: 'POST',
                context: this,
                url: '{{ route('admin.payment.default.update') }}',
                data: {
                    id: id,
                    _token: token
                },
                success: function(data) {
                    // do nothing;
                    if (data.status == false) {
                        toastr.error(data.msg);
                    } else {
                        toastr.success(data.msg);
                        $('.payment_default_change').prop('checked', false);
                        $('#payment_default_change_' + data.id).prop('checked', true);
                    }
                }
            });
        });
    })(jQuery);
</script>
