@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <a class="breadcrumb-item text-white" href="{{ route('admin.place.index') }}">{{ __('Place') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title">{{ __($title) }}</h6>
                    </div>
                    <form action="{{ $place ? route('admin.place.update', $place->id) : route('admin.place.store') }}"
                        method="post" enctype="multipart/form-data">
                        @csrf
                        @if ($place)
                            @method('PATCH')
                        @endif
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold">{{ __('Place Name :') }} </p>
                                        <input type="text" name="name" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Place Name') }}"
                                            value="{{ $place ? $place->name : old('name') }}" required>
                                        @error('name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <p class="h6 mb-3">{{ __('Place Primary Image') }}:<code>{{__('(Only jpeg, png, jpg and gif file is
                                        acceptable)')}}</code></p>
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <div class="">
                                                <div class="thumbnail-image" id="bg_image">
                                                    <div class="input-images"></div>
                                                </div>
                                            </div>
                                        </div>
                                        @if($place)
                                        <div class="col-md-6 text-center">
                                            {!! imageShow($place->place_primary_image, 'Image', 'img-thumbnail', 'width="35%" height="200"',  'App\Models\Place', $place->id, 'place_primary_image') !!}

                                        </div>
                                        @endif
                                    </div>
                                    @error('images.0')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit">{{ __('Submit form') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    @include('backend.pages.place.internal-assets.js.page-scripts')
    @include('backend.layouts.message')
    @include('backend.pages.delete-warning')
@endsection
