<div class="row">
    <div class="col-12">
        <div class="card card-dark bg-dark py-1">
            <div class="card-body p-4">
                <div class="row">
                    <div class="col-md-4 py-5">
                        <div class="h5">{{ __('Profile Information') }}</div>
                        <p class="">{{ __('Update your account profile information.') }}</p>
                    </div>
                    <div class="col-md-8">
                        <form action="{{ route('admin.profile-update') }}" method="post" enctype="multipart/form-data"
                            class="wma-form">
                            @csrf
                            <div class="">
                                <p class="h6 mb-3">{{ __('Photo') }}</p>
                                <div class="row">
                                    <div class="col-md-6 text-center">
                                        @if (Auth::user()->getAttributes()['profile_photo_path'] != null)
                                            {!! imageShow(asset(UPLOAD_FOLDER_USER.Auth::user()->getAttributes()['profile_photo_path']), Auth::user()->name, 'rounded-circle', 'width="150" height="150"') !!}
                                        @else
                                            <img src="{{ Auth::user()->gender == 'male' ? asset('backend/assets/img/profile/male.jpg') : (Auth::user()->gender == 'female' ? asset('backend/assets/img/profile/female.jpg') : asset('backend/assets/img/profile/other.png')) }}"
                                                class="rounded-circle " width="150">
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div class="">
                                            <div class="admin-image" id="admin_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    <div class="col">
                                        <p class="mb-1 font-weight-bold"><label for="name">{{ __('Name') }}:</label>
                                        </p>
                                        <div class="input-group input-group-lg mb-3">
                                            <input type="text" name="name" id="name" value="{{ Auth::user()->name }}"
                                                class="form-control rounded" aria-label="Large"
                                                placeholder="{{ __('Name in English') }}"
                                                aria-describedby="inputGroup-sizing-sm">
                                            <br>
                                            @if ($errors->has('name'))
                                                <span class="text-danger">{{ $errors->first('name') }}</span>
                                            @endif
                                        </div>
                                        <p class="mb-1 font-weight-bold"><label
                                                for="email">{{ __('Email') }}:</label> </p>
                                        <div class="input-group input-group-lg mb-3">
                                            <input type="email" name="email" id="email"
                                                value="{{ Auth::user()->email }}" class="form-control rounded"
                                                aria-label="Large" aria-describedby="inputGroup-sizing-sm">
                                            <br>
                                            @if ($errors->has('email'))
                                                <span class="text-danger">{{ $errors->first('email') }}</span>
                                            @endif
                                        </div>
                                        {{-- about me --}}
                                        <div class="form-group">
                                            <label for="pageContent">
                                                <span
                                                    class="d-block card-title mb-1 font-weight-bold">{{ __('Description :') }}
                                                </span>
                                            </label>
                                            <textarea name="about_me" id="about_me" rows="5" class="form-control "
                                                placeholder="{{ __('About Me...') }}">{{ auth()->user()->about_me }}</textarea>
                                            @error('about_me')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        {{-- end about me --}}
                                    </div>
                                </div>
                                <div class="float-right">
                                    <button class="btn btn-wave-light rounded btn-danger btn-lg"
                                        type="submit">{{ __('Save') }}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
