@extends('backend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title">
                            <a class="btn btn-warning" href="{{ route('admin.settings.google.login') }}">
                                <i class="fas fa-check mr-2"></i> {{ __($google_title) }}</a> |
                            <a class="btn btn-primary" href="{{ route('admin.settings.facebook.login') }}">
                                {{ __($facebook_title) }}</a>
                        </h6>
                    </div>
                    <div class="card-body ">
                        <form action="{{ route('admin.settings.google.login') }}" method="POST" enctype="multipart/form-data"
                            class="wma-form">
                            @csrf
                            <p class="mb-1">{{ __('Is active google oauth?') }} </p>
                            <div class="input-group input-group-lg mb-3">
                                <label class="switch">
                                    <input type="checkbox" name="is_login" {{ env('ENABLE_GOOGLE_LOGIN') == 'yes' ? 'checked' : '' }} class="blogIsFeaturedBtn">
                                    <span class="slider round"></span>
                                </label>
                            </div>

                            <div class="mb-3">
                                <p class="mb-1">{{ __('Google Client ID:') }} </p>
                                <div class="input-group input-group-lg">
                                    <input type="text" name="client_id" class="form-control @error('client_id') is-invalid @enderror" aria-label="Large"
                                           aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Google Client ID') }}"
                                           value="{{ old('client_id', env('GOOGLE_OAUTH_CLIENT_ID')) }}">
                                </div>
                                @error('client_id')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <p class="mb-1">{{ __('Google Client Secret ID') }} </p>
                                <div class="input-group input-group-lg">
                                    <input type="text" name="client_secret" class="form-control @error('client_secret') is-invalid @enderror" aria-label="Large"
                                           aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Google Client Secret ID') }}"
                                           value="{{ old('client_secret', env('GOOGLE_OAUTH_CLIENT_SECRET')) }}">
                                </div>
                                @error('client_secret')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>



                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit">{{ __('Submit form') }}</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

@section('page-script')
    @include('backend.layouts.message')
@endsection
