@extends('backend.layouts.master-layout')

@section('title', config('app.name', 'laravel').' | '.$title)

@section('page-css')

@endsection

@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{__('Home')}}</a>
                    <a class="breadcrumb-item text-white"
                       href="{{ route('admin.team.index') }}">{{__('Team')}}</a>
                    <span class="breadcrumb-item active">{{__($title)}}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title">{{__($title)}}</h6>
                    </div>
                    <form
                        action="{{ $attorney? route('admin.team.update',$attorney->id) : route('admin.team.store') }}"
                        method="POST" enctype="multipart/form-data">
                        @csrf
                        @if($attorney)
                            @method('PATCH')
                        @endif
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-6 pr-2">
                                    <div class="mb-3">
                                        <p class="mb-1 font-weight-bold">{{__('Name :')}} </p>
                                        <div class="input-group input-group-lg">
                                            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" aria-label="Large"
                                                   aria-describedby="inputGroup-sizing-sm"
                                                   placeholder="{{__('Team member name')}}"
                                                   value="{{ $attorney?$attorney->name:old('name') }}">
                                        </div>
                                        @if ($errors->has('name'))
                                            <span class="text-danger">{{ $errors->first('name') }}</span>
                                        @endif
                                    </div>

                                    <div class="mb-3">
                                        <p class="mb-1 font-weight-bold">{{__('Email :')}} </p>
                                        <div class="input-group input-group-lg">
                                            <input type="email" name="email"
                                                   class="form-control @error('email') is-invalid @enderror"
                                                   aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                                   placeholder="{{__('Team member email')}}"
                                                   value="{{ $attorney?$attorney->email:old('email') }}">
                                        </div>
                                        @if ($errors->has('email'))
                                            <span class="text-danger">{{ $errors->first('email') }}</span>
                                        @endif
                                    </div>

                                    <div class="mb-3">
                                        <p class="mb-1 font-weight-bold">{{__('Designation Name:')}} </p>
                                        <div class="input-group input-group-lg">
                                            <select class="form-control form-control-lg @error('name') is-invalid @enderror" name="designation_id">
                                                @foreach($designation as $data)
                                                    <option
                                                        value="{{$data?$data->id:old('name')}}" @if(!empty($attorney)){{$attorney->designation->id==$data->id?'selected':''}}@endif>{{$data->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if ($errors->has('name'))
                                            <span class="text-danger">{{ $errors->first('name') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="col-md-6 pl-3">
                                    <div class="mb-3">
                                        <p class="mb-1 font-weight-bold">{{__('Phone : ')}}</p>
                                        <div class="input-group input-group-lg">
                                            <input type="text" name="phone"
                                                   class="form-control @error('phone') is-invalid @enderror"
                                                   aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                                   placeholder="{{__('Attorney phone')}}"
                                                   value="{{ $attorney?$attorney->phone:old('phone') }}">
                                        </div>
                                        @if ($errors->has('phone'))
                                            <span class="text-danger">{{ $errors->first('phone') }}</span>
                                        @endif
                                    </div>

                                    <table class="table table-responsive-sm mb-0">

                                        <tr>
                                            <td class="pl-0">
                                                <label for="programStatus">
                                                    <span class="font-weight-bold">{{__('Publish Status')}}</span>
                                                </label>
                                            </td>

                                            <td>
                                                <label class="switch float-left">
                                                    <input type="checkbox" name="status"
                                                           {{ $attorney?($attorney->status==true?'checked':''):'' }} id="programStatus">
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>

                                    </table>

                                </div>
                            </div>

                            <div class="mb-3">
                                <p class="mb-1 font-weight-bold">{{__('Address :')}} </p>
                                <textarea name="address" id="address" rows="6" class="form-control @error('address') is-invalid @enderror"
                                          placeholder="{{__('Team member address here')}}">{!! clean($attorney?$attorney->address:old('address')) !!}</textarea>
                                @if ($errors->has('address'))
                                    <span class="text-danger">{{ $errors->first('address') }}</span>
                                @endif
                            </div>


                            <p class="mb-1 font-weight-bold">{{__('Description :')}} </p>
                            <div class=" mb-3">
                                <textarea name="description" id="description" rows="6"
                                          class="form-control bapric_edittor @error('description') is-invalid @enderror"
                                          placeholder="{{__('Team member description here')}}">{!! clean($attorney?$attorney->description:old('description')) !!}</textarea>
                                @if ($errors->has('description'))
                                    <span class="text-danger">{{ $errors->first('description') }}</span>
                                @endif
                            </div>


                            <div class=" ">
                                <p class="mb-2 font-weight-bold">{{__('Image : ')}}
                                    <code>{{('Acceptable image size 370 x 336 pixel')}}</code></p>
                                <div class="mb-3">
                                    <div class="partner_bg_image" id="partner_bg_image">
                                        <div class="input-images"></div>
                                    </div>
                                </div>
                            </div>

                            @if($attorney)
                                <div class="pr-2 ">
                                    <p class="mb-2 font-weight-bold ">{{__('Old Image :')}} </p>
                                    {!! imageShow($attorney->image, 'Image', '', 'width="200"', 'App\Models\Attorney', $attorney->id, 'image') !!}
                                </div>
                            @endif


                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit">{{__('Submit form')}}</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection

@section('page-script')
    @include('backend.pages.team.internal-assets.js.attorney-page-scripts')
    @include('backend.layouts.message')
    @include('backend.pages.delete-warning')
@endsection
