@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <nav
                        class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                        <a class="breadcrumb-item text-white"
                           href="{{route('admin.testimonial.index')}}">{{__('Home')}}</a>
                        <span class="breadcrumb-item active">{{__($title)}}</span>
                        <span class="breadcrumb-info" id="time"></span>
                    </nav>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card card-dark bg-dark">
                        <div class="card-header">
                            <h6 class="card-title">{{__($title)}}</h6>
                        </div>
                        <form class="" action="{{route('admin.testimonial.store')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-7">
                                        <div class="mb-3">
                                            <p class="mb-1">
                                                <label for="name" class="card-title font-weight-bold">{{ __('Name:') }}</label>
                                            </p>
                                            <div class="input-group input-group-lg">
                                                <input type="text" name="name" id="name" class="form-control" placeholder="{{ __('Name') }}" value="">
                                            </div>
                                            @if ($errors->has('name'))
                                                <span class="text-danger">{{ $errors->first('name') }}</span>
                                            @endif
                                        </div>

                                        <div class="mb-3">
                                            <p class="mb-1">
                                                <label for="designation" class="card-title font-weight-bold">{{ __('Designation:') }}</label>
                                            </p>
                                            <div class="input-group input-group-lg">
                                                <input type="text" name="designation" id="designation" class="form-control" placeholder="{{ __('Designation') }}" value="">
                                            </div>
                                            @if ($errors->has('designation'))
                                                <span class="text-danger">{{ $errors->first('designation') }}</span>
                                            @endif
                                        </div>

                                        <div class="mb-3">
                                            <p class="mb-1">
                                                <label for="video_link" class="card-title font-weight-bold">{{ __('Video Link:') }}</label>
                                            </p>
                                            <div class="input-group input-group-lg">
                                                <input type="text" name="video_link" id="video_link" class="form-control" placeholder="{{ __('Video Link') }}" value="">
                                            </div>
                                            @if ($errors->has('video_link'))
                                                <span class="text-danger">{{ $errors->first('video_link') }}</span>
                                            @endif
                                        </div>

                                        <div class="mb-3">
                                            <label for="testimonial" class="card-title font-weight-bold">{{ __('Testimonial') }}:</label>
                                            <textarea rows="10" name="testimonial" id="testimonial" class="form-control rounded">{!! clean(old('testimonial')) !!}</textarea>
                                            @error('testimonial')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                    </div>

                                    <div class="col-md-5">
                                        <div class="mb-3">
                                            <p class="h6">{{ __('Image') }}:
                                                <code>{{ __('Acceptable image size 96 x 96 pixels') }}</code>
                                            </p>
                                            <div class="subject-thumbnail" id="subject-thumbnail">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <p class="h6">{{ __('Status:') }}</p>
                                            <label class="switch float-left">
                                                <input type="checkbox" name="status" id="programStatus">
                                                <span class="slider round"></span>
                                            </label>
                                        </div>
                                        <br><br>
                                        <div class="mb-3">
                                            <p class="h6">{{ __('Rating:') }}</p>
                                            <select name="rating" class="form-control">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <option value="{{ $i }}">{{ $i }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer">
                                <button class="btn btn-wave-light btn-danger btn-lg" type="submit">{{ __('Submit Form') }}</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    @include('backend.pages.testimonial.internal-assets.js.testimonial-scripts')
    @include('backend.layouts.message')
@endsection
