@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
@endsection
@section('content')
<div id="wrapper-content">
    <div class="row">
        <div class="col">
            <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                <a class="breadcrumb-item text-white" href="{{route('admin.dashboard')}}">{{__('Home')}}</a>
                <span class="breadcrumb-item active">{{ __($title) }}</span>
                <span class="breadcrumb-info" id="time"></span>
            </nav>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card card-dark bg-dark">
                <div class="card-header d-block">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <h6 class="card-title lh-35">{{ __($title) }}</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="slider" class="table bapric_table data-table table-striped table-bordered miw-500" cellspacing="0" width="100%">
                            <thead>
                            <tr>
                                <th width="5%">{{__('SL')}}</th>
                                <th>{{__('Name')}}</th>
                                <th>{{__('Email')}}</th>
                                <th>{{__('Phone')}}</th>
                                <th>{{__('Address')}}</th>
                                <th width="10%">{{__('Action')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                              </button>
                            </div>
                            <div class="modal-body text-dark">
                              <div class="text-center" id="prof-img">
                                  
                              </div>
                              <div class="row">
                                  <div class="col-6 ">
                                      <button class="btn btn-primary float-right">{{__('User ID :')}} <strong id="user_id"></strong></button>
                                  </div>
                                  <div class="col-6 float-left">
                                    <button class="btn btn-primary">{{__('Joining Date :')}} <strong id="joining_date"></strong> </button>
                                  </div>
                              </div>
                              <table class="table  text-center mt-4">
                                  <tr >
                                      <td width="30%" class="text-right">{{__('Name :')}}</td>
                                      <td id="name"></td>
                                  </tr>
                                  <tr>
                                    <td class="text-right">{{__('Email :')}}</td>
                                    <td id="email"></td>
                                  </tr>
                                  <tr>
                                    <td class="text-right">{{__('Phone :')}}</td>
                                    <td id="phone"></td>
                                  </tr>
                                  <tr>
                                    <td class="text-right">{{__('Adress :')}}</td>
                                    <td id="adress"></td>
                                  </tr>
                                  <tr>
                                    <td class="text-right">{{__('About Me :')}}</td>
                                    <td id="about_me"></td>
                                  </tr>
                              </table>
                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
                              <button type="button" class="btn btn-primary">{{__('Save changes')}}</button>
                            </div>
                          </div>
                        </div>
                      </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/js/user-role-and permission.js') }}"></script>
    <script src="{{ asset('backend/assets/js/userView.js') }}"></script>
    @include('backend.pages.users.client.internals.datatable')
    @include('backend.pages.users.client.internals.load-data')
@endsection
