@extends('frontend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@push('page-css')
@endpush
@section('content')

<section class="inner-area parallax-bg"
    style="@if(!empty($pageContent->bg_img))background-image: url({{asset($pageContent->bg_img)}});@else background-image: url({{asset('frontend/images/bg/px-1.jpg')}}); @endif">
    <div class="container">
        <div class="section-content">
            <div class="row">
                <div class="col-12">
                    <h4>{{isset($title)?$title:''}}</h4>
                    <p><a href="{{ route('home') }}">{{ __('Home') }}</a> <a href="#">{{isset($title)?$title:''}}</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>



<!-- SIGN-IN SECTION -->
<div class="container">
    <div class="card card-body col-md-6 offset-md-3 my-sm-4 ">
        <div class="box-account o">
            @if ($pageContent && $pageContent->show)
            <form class="box-account-form" action="{{ route('guest.post.login') }}" method="post">
                @csrf
                <span class="reauth-email"> </span>
                <div class="form-group">
                    <label for="floatingInput">{{ __('Enter your email:') }}</label><sup class="text-danger">*</sup>
                    <input class="form-control" type="email" name="email" value="{{ old('email') }}" required
                        placeholder="{{ __('Email') }}" id="inputPseudo">
                    @error('email')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-gropu">
                    <label for="floatingInput">{{ __('Enter your password:') }}</label><sup class="text-danger">*</sup>
                    <input class="form-control" type="password" name="password" required
                        placeholder="{{ __('Password') }}" id="inputPassword">
                    @error('password')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="custom-control custom-checkbox pb-2">
                    <input type="checkbox" name="remember" class="custom-control-input" id="customCheck1">
                    <label class="custom-control-label" for="customCheck1">{{ __('Remember me') }}</label>
                </div>
                <button class="btn-login btn-lg btn-block btn-wave-light" type="submit">{{ __('Login') }}</button>
            </form>
            @endif
            <div class="mb-2">
                @if (env('ENABLE_GOOGLE_LOGIN') == 'yes')
                <p class="mx-auto text-center">{{ __('OR') }}</p>
                <a href="{{ route('oauth.redirect', OAUTH_TYPE_GOOGLE) }}" class="btn btn-info btn-block text-white"><i
                        class="fa fa-google float-left pl-3 mt-1"></i>
                    {{ __('Login with Google') }}</a>
                @endif
                @if (env('ENABLE_FACEBOOK_LOGIN') == 'yes')
                <a href="{{ route('oauth.redirect', OAUTH_TYPE_FACEBOOK) }}"
                    class="btn btn-danger btn-block text-white"><i class="fa fa-facebook float-left pl-3 mt-1 "></i>
                    {{ __('Login with Facebook') }}</a>
                @endif
            </div>
            <div class="row pt-2">
                <div class="col-md-6">
                    <p class="box-account-text ">{{ __('Forgot your password') }} ? <a
                            href="{{ route('guest.forget.password') }}" class="text-info text-grey">{{ __('Recover')
                            }}</a></p>
                </div>
                <div class="col-md-6 text-right">
                    <a href="{{ route('guest.register') }}" class="text-info text-grey">{{ __('New Register') }}</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END SIGN-IN SECTION -->
@endsection

@push('page-script')


@endpush