<div class="l-sidebar">
    <div class=" sidebar__content ">
        <div class="text-center position-relative mb-3">
            @if (Auth::user()->getAttributes()['profile_photo_path'] != null)
                {!! imageShow(asset(UPLOAD_FOLDER_USER . Auth::user()->getAttributes()['profile_photo_path']), Auth::user()->name, 'rounded-circle w-75 border border-dark', 'width="100"') !!}
            @else
                <img src="{{ Auth::user()->gender == 'male' ? asset('backend/assets/img/profile/male.jpg') : (Auth::user()->gender == 'female' ? asset('backend/assets/img/profile/female.jpg') : asset('backend/assets/img/profile/other.png')) }}"
                    class="rounded-circle w-75 border border-dark" />
            @endif
            <span class="rounded-circle border bottom-0 right-3 profile_image_icon" data-toggle="modal" data-target="#profileImageModal">
                <svg width="16" height="16" fill="currentColor" class="bi bi-camera-fill" viewBox="0 0 16 16">
                    <path d="M10.5 8.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0z"/>
                    <path d="M2 4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1.172a2 2 0 0 1-1.414-.586l-.828-.828A2 2 0 0 0 9.172 2H6.828a2 2 0 0 0-1.414.586l-.828.828A2 2 0 0 1 3.172 4H2zm.5 2a.5.5 0 1 1 0-1 .5.5 0 0 1 0 1zm9 2.5a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0z"/>
                </svg>
            </span>
        </div>
        <div class="clearfix"></div>
        <nav class="c-menu js-menu text-white bg-dark">
            <ul class="nav nav-pills flex-column mb-auto">
                <li><a href="{{ route('guest.dashboard') }}"
                        class="nav-link text-white {{ request()->is('user-dashboard') ? 'active' : '' }}"
                        aria-current="page"><i class="fa fa-dashboard mr-2"></i>{{ __('Dashboard') }}</a></li>
                <li><a href="{{ route('guest.profile.update') }}"
                        class="nav-link text-white {{ request()->is('user-profile-update') ? 'active' : '' }}"><i
                            class="fa fa-address-book-o mr-2"></i>{{ __('Profile Update') }}</a></li>
                <li><a href="{{ route('guest.hotel.order') }}"
                        class="nav-link text-white {{ request()->is('user-hotel-order') ? 'active' : '' }}"><i
                            class="fa fa-building-o mr-2"></i>{{ __('Hotel Order') }}</a></li>
                <li><a href="{{ route('guest.package.order') }}"
                        class="nav-link text-white {{ request()->is('user-package-order') ? 'active' : '' }}"><i
                            class="fa fa-globe mr-2"></i>{{ __('Package Order') }}</a></li>
                <li><a href="{{ route('guest.logout') }}" class="nav-link text-white"><i
                            class="fa fa-sign-out mr-2"></i>{{__('Log Out')}}</a></li>
            </ul>
        </nav>
    </div>
</div>

<!-- Profile Image Modal -->
<div class="modal fade" id="profileImageModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">{{ __('Upload your profie image') }}</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('guest.profile.image.update') }}" enctype="multipart/form-data" method="post">
            <div class="modal-body">
                @csrf
                <p class=" font-weight-bold"><label
                    for="name">{{ __('If you want to change, Please choose your image') }}:</label>
                <input type="file" name="profile_photo_path" class="form-control-file" accept="image/*" />
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
                <button type="submit" class="btn btn-primary">{{__('Save changes')}}</button>
            </div>
        </form>
      </div>
    </div>
  </div>