@extends('frontend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@push('page-css')

@endpush


@section('content')

    <section class="inner-area parallax-bg" style="background-image: url({{ asset('frontend/images/bg/px-1.jpg') }});">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ __('Login in ') }}{{ Auth::user()->name }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a> <a
                                href="{{ route('guest.dashboard') }}">{{ __('User Details') }}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="latest-hotel-sec pt-85 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-3">
                    @include('frontend.auth.menus.sidebar')
                </div>
                <div class="col-sm-9">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <a href="{{ route('guest.hotel.order') }}" class="card card-body bg-success text-light text-center">
                                        <i class="fa fa-building-o fa-3x float-left mb-2"></i>
                                        {{ __('Total Hotel Order') }}
                                        <h4 class="text-light">{{ $hotel_order_count }}</h4>
                                    </a>
                                </div>
                                <div class="col-sm-6">
                                    <a href="{{ route('guest.package.order') }}" class="card card-body bg-info text-light text-center">
                                        <i class="fa fa-globe fa-3x float-left mb-2"></i>
                                        {{ __('Total Package Order') }}
                                        <h4 class="text-light">{{ $package_order_count }}</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('page-script')
    @if (Cookie::get(COOKIE_LOGIN_AFTER_URL))
        <script>
            (function($) {
                "use strict";
                location.replace('{{ Cookie::get(COOKIE_LOGIN_AFTER_URL) }}');
            })(jQuery);
        </script>
    @endif
@endsection
