
<section class="client-section bg-f8 pb-70 pt-70">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div id="client_carousel" class="owl-carousel">
                    @foreach($partners as $partner)
                    <div class="item">
                        <div class="client-img-item">
                            {!! imageShow($partner->image) !!}
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Client Section End -->

<!-- Footer Style Seven Start -->
<footer class="bg-faded pt-70 pb-40 bg-theme-color-2">
    <div class="container">
        <div class="section-content">
            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-12">
                    <div class="footer-item footer-widget-one">
                        @if ($footerData)
                            {!! imageShow($footerData->footer_logo) !!}
                        @endif
                        <br>
                        <p>{{$footerData?$footerData->column1_short_disc:''}}</p>
                        <hr>
                        <h6>{{$footerData?$footerData->show_social_title:''}}</h6>
                        <ul class="social-icon bg-transparent bordered-theme">
                            @foreach($social_media as $media)
                                @if($media->url)
                                    <li><a href="{{$media->url}}" target="_blank" class="btn-theme-outline-green btn-card-social-circle"><i class="fa fa-{{$media->name}}"></i></a></li>
                                @endif
                            @endforeach
                        </ul>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-12">
                    <div class="footer-item">
                        <div class="footer-title">
                            <h4>{{ $footerData?$footerData->column2_recent_post_title:'' }}</h4>
                            <div class="border-style-3"></div>
                        </div>
                        <ul class="footer-list">
                            @foreach($featured_post as $fpost)
                                <li><a href="{{route('view-single-blog-page',$fpost->slug)}}">{{ Str::limit($fpost->title,'19','...') }}</a></li>
                            @endforeach
                        </ul>

                    </div>
                </div>


                <div class="col-lg-3 col-md-6 col-sm-12">
                    <div class="footer-item">
                        <div class="footer-title">
                            <h4>{{ $footerData?$footerData->column3_popular_post_title:''}}</h4>
                            <div class="border-style-3"></div>
                        </div>
                        <ul class="footer-list">
                            @foreach($popular_post as $ppost)
                                <li><a href="{{route('view-single-blog-page',$ppost->slug)}}">{{ Str::limit($ppost->title,'19','...') }}</a></li>
                            @endforeach
                        </ul>

                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-12">
                    <div class="footer-item">
                        <div class="footer-title">
                            <h4>{{clean($footerData?$footerData->column4_title:'')}}</h4>
                            <div class="border-style-3"></div>
                        </div>
                        <ul class="footer-list footer-contact mb-10">
                            <p>{!! clean($footerData?$footerData->column4_description:'') !!}</p>
                        </ul>
                        <div class="footer-item">
                            @if ($footerData && $footerData->bottom_footer_show)
                                <h6>{!! clean($footerData?$footerData->news_latter_form_title:'') !!}</h6>
                                <form action="{{route('news-letter')}}" method="post">
                                    @csrf
                                    <div class="input-group subscribe-style-two">
                                        <div class="mb-3">
                                            <input type="email" name="email" class="form-control input-subscribe @error('email') is-invalid @enderror" placeholder="{{__('Email')}}">
                                            @if($errors->has('email'))
                                                <span class="text-danger">{{$errors->first('email')}}</span>
                                            @endif
                                        </div>
                                            <span class="input-group-btn">
                                              <button class="btn btn-subscribe" type="submit">{{__('Subscribe')}}</button>
                                            </span>
                                    </div>
                                </form>
                            @endif
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<section class="footer-copy-right bg-theme-color-2 text-white p-0">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <p>{{ clean($footerData?$footerData->footer_copy_right:'') }}</p>
            </div>
        </div>
    </div>
</section>

<a href="#" class="scrollup"><i class="flaticon-long-arrow-pointing-up" aria-hidden="true"></i></a>
