@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')
    <link rel="stylesheet" href="{{ asset('frontend/plugins/sollist-master/sollist.css') }}">
@endsection

@section('content')
    @if ($commentSettings)
        <div class="d-none">{!! $commentSettings->code !!}</div>
    @endif

    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($pageContent->bg_img))background-image: url({{ asset($pageContent->bg_img) }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ clean($title ? $title : '') }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a> <a
                                href="{{ route('blog') }}">{{ __('blog') }}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->
    <!-- Blog Section Start -->
    <section class="blog-section">
        <div class="container">
            <div class="row">
                <div class="col-md-8 col-lg-9">
                    <div class="blog-details">
                        <div class="details-thumb">
                            {!! imageShow($blog->bg_image, __('Blog Image')) !!}
                        </div>
                        <div class="details-content mb-40">
                            <h4>{{ clean($blog ? $blog->title : '') }}</h4>
                            <p class="mb-20">{!! clean($blog ? $blog->description : '') !!}</p>
                            <ul class="details-tag mb-40">
                                <li><a href="#"><i
                                            class="pe-7s-stopwatch"></i>{{ date('d-M-Y', strtotime($blog->created_at)) }}</a>
                                </li>
                                <li><a href="#"><i class="pe-7s-user"></i>{{ clean($blog->userId->name) }}</a></li>
                                <li><a href="#"><i class="pe-7s-folder"></i>{{ clean($blog->category->name) }}</a></li>
                            </ul>
                            @include('frontend.share-link',['route'=>route('view-single-blog-page', $blog->slug)])
                            <div class="btn-box mt-60">
                                @if ($previous)<a class="float-left" href="{{ route('view-single-blog-page', ['slug' => $previous->slug]) }}">{{ __('previous') }}</a>@endif
                                @if ($next)<a class="float-right" href="{{ route('view-single-blog-page', ['slug' => $next->slug]) }}">{{ __('next') }}</a>@endif
                            </div>
                        </div>

                        <!-- Blog Post Author -->
                        <div class="blog-admin mb-5">
                            <div class="blog-admin-desc">
                                <div class="clearfix">
                                    <h5>{{ $blog->userId->name }}</h5>
                                </div>
                                <p class="mb-15">{{ $blog->userId->about_me }}</p>
                            </div>
                        </div>
                        @if ($commentSettings->code)
                            <!-- End Blog Post Author -->
                            <div class="mb-5">
                                <h4>{{ __('Comments') }}</h4>
                                <div class="border-style-2"></div>
                            </div>

                            <div class="fb-comments" data-href="{{ route('view-single-blog-page', $blog->slug) }}"
                                data-width="" data-numposts="5"></div>
                            <!-- Blog Comments -->
                        @endif
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="theme-sidebar">

                        <div class="widget search-sidebar">
                            <div class="title-box">
                                <h3>{{ __('Search') }} <span>{{ __('Here') }}</span></h3>
                            </div>
                            <form action="{{ route('search-blog') }}" method="GET" class="search-box" role="search">
                                <div class="form-group">
                                    <input type="text" name="search" placeholder="Search" class="form-control">
                                    <i class="fa fa-search form-control-feedback search_btn"></i>
                                    <button type="submit" class="d-none"></button>
                                </div>
                            </form>
                        </div>

                        @if (!empty($categories))
                            <div class="widget">
                                <div class="title-box">
                                    <h3>{{ __('Categories') }} <span></span></h3>
                                </div>
                                <div class="cat-item">
                                    <ul>
                                        @foreach ($categories as $category)
                                            <li><a
                                                    href="{{ route('blog-category', $category->id) }}">{{ $category->name }}</a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        @endif

                        @if (!empty($recentBlogs))
                            <div class="widget">
                                <div class="title-box">
                                    <h3>{{ __('Recent') }} <span>{{ __('posts') }}</span></h3>
                                </div>
                                @foreach ($recentBlogs as $recentBlog)
                                    <div class="blog-small-item">
                                        {!! imageShow($recentBlog->feature_img, __('Blog Image')) !!}
                                        <div class="tex">
                                            <h5><a
                                                    href="{{ route('view-single-blog-page', ['slug' => $recentBlog->slug]) }}">{{ Str::limit($recentBlog ? $recentBlog->title : '',30) }}</a>
                                            </h5>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                        @if (!empty($blogTags))
                            <div class="widget">
                                <div class="title-box">
                                    <h3>{{ __('Tag ') }}<span>{{ __('Cloud') }}</span></h3>
                                </div>
                                <div class="tags-item">
                                    @foreach ($blogTags as $blogTag)
                                        <a
                                            href="{{ route('blog-tag', $blogTag->tag_id) }}">{{ $blogTag->tag_name }}</a>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Blog Section End -->
@endsection
@section('page-script')
@endsection
