@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')
    <link rel="stylesheet" href="{{ asset('frontend/css/images-grid.css') }}">
    <link rel="stylesheet" href="{{ asset('css/daterangepicker.css') }}">
@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" data-background="{{asset('frontend/images/bg/px-1.jpg')}}" data-type="parallax"
        data-speed="3">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? clean($title) : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? clean($title) : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->
    <!-- Contact Section Start -->
    <div class="container mt-3">
        @if (Session::get('message'))
            <div class="alert alert-success">{{ Session::get('message') }}</div>
        @endif
    </div>
    <section class="contact-section pt-5 pb-20">
        <div class="container">
            <div class="row contact-bg">
                <div class="col-md-12 col-lg-4 p-0">
                    <div class="contact-text">
                        <h2>{{ __('We are') }} <span>{{ __('Booking') }}</span></h2>
                        <h4>{{ clean($accommodation->hotel->hotel_name) }}</h4>
                        <div class="sec-line mb-20"></div>
                        <div class="contact-info">
                            <div class="icon-box">
                                <i class="flaticon-pin-1"></i>
                            </div>
                            <h6>{{ __('Country: ') }} {{ clean($accommodation->hotel->hotelCountry->name . ', ') }}</h6>
                            <h6>{{ __('City: ') }} {{ clean($accommodation->hotel->hotelCity->name . ', ') }}</h6>
                        </div>
                        <div class="contact-info">
                            <div class="icon-box">
                                <i class="flaticon-flash"></i>
                            </div>
                            <h6>{{ clean($accommodation->hotel->phone . ', ') }}</h6>
                        </div>
                        <div class="contact-info">
                            <div class="icon-box">
                                <i class="pe-7s-map"></i>
                            </div>
                            <h6><a
                                    href="mailto:{{ $accommodation->hotel->email }}">{{ clean($accommodation->hotel->email . ', ') }}</a>
                            </h6>
                        </div>
                        @if ($accommodation->hotel && $accommodation->hotel->website)
                            <div class="contact-info">
                                <div class="icon-box">
                                    <i class="pe-7s-server"></i>
                                </div>
                                <h6><a
                                        href="{{ $accommodation->hotel->website }}">{{ clean($accommodation->hotel->website) }}</a>
                                </h6>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="col-md-12 col-lg-8 style-2">
                    <form class="booking-form" method="post" action="{{ route('booking.hotel.save') }}">
                        @csrf
                        <div class="form-row">
                            <div class="form-group col-md-12 mb-1">
                                <label for="">{{ __('Accommodation') }}</label>
                                <select name="hotel_accommodation_id" class="form-control mb-0">
                                    @foreach ($hotel_accommodations as $hotel_accommodation)
                                        <option {{ $hotel_accommodation->id == $accommodation->id ? 'selected' : '' }}
                                            value="{{ $hotel_accommodation->id }}">
                                            {{ $hotel_accommodation->accommodation->name . ' (' . discountPriceCalculate($hotel_accommodation->price, $discount)['price'] . ') (' . $hotel_accommodation->no_of_guest . __('Person') . ')' }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('hotel_accommodation_id')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-7 mb-1">
                                <label for="">{{ __('Check In out') }}</label>
                                <input type="text" id="datetimepicker" name="check_in_out" class="form-control" />
                                @error('check_in_out')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group col-md-5 mb-1">
                                <label for="">{{ __('Arrival Time') }}</label>
                                <input type="text" id="arrival_date_time" name="arrival_date_time" class="form-control" />
                                @error('arrival_date_time')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-6 mb-1">
                                <label for="">{{ __('First Name') }}</label>
                                <input type="text" name="first_name" value="{{ Auth::user()->name }}" class="form-control mb-1"
                                    value="{{ old('first_name') }}" />
                                @error('first_name')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-6 mb-1">
                                <label for="">{{ __('Last Name') }}</label>
                                <input type="text" name="last_name" value="{{ Auth::user()->surname }}" class="form-control mb-1"
                                    value="{{ old('last_name') }}" />
                                @error('last_name')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-6 mb-4">
                                <label for="">{{ __('Email') }}</label>
                                <input type="email" name="email" value="{{ Auth::user()->email }}" class="form-control mb-0" placeholder="Email"
                                    value="{{ old('email') }}" />
                                @error('email')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                                <small class="text-mute">{{ __('Confirmation email sent to this address') }}</small>
                            </div>
                            <div class="form-group col-md-6 mb-4">
                                <label for="">{{ __('Are you traveling for work?') }}</label>
                                <div class="clearfix"></div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="is_travel_for_work_yes"
                                        name="is_travel_for_work" value="{{ ACTIVE_STATUS }}">
                                    <label class="form-check-label" for="is_travel_for_work_yes">
                                        {{ __('Yes') }}</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" id="is_travel_for_work_no"
                                        name="is_travel_for_work" value="{{ DEACTIVE_STATUS }}" checked>
                                    <label class="form-check-label" for="is_travel_for_work_no">
                                        {{ __('No') }}</label>
                                </div>
                            </div>

                            <div class="form-group col-md-12">
                                <div class="contact-textarea text-center">
                                    <button class="btn btn-theme" type="submit"
                                        value="Submit Form">{{ __('Reserve') }}</button>
                                </div>
                                <input type="hidden" name="hotel_id" value="{{ clean($accommodation->hotel_id) }}">
                                <input type="hidden" name="discount_id" value="{{ clean((($discount) ? $discount->id : '')) }}">
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>
    <!-- Contact Section End -->
@endsection

@section('page-script')
    <script type="text/javascript" src="{{ asset('js/moment.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/daterangepicker.js') }}"></script>
    @include('frontend.pages.booking.script')
@endsection
