@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
<!-- Inner Section Start -->
<section class="inner-area parallax-bg" style="@if(!empty($pageContent->bg_img))background-image: url({{asset($pageContent->bg_img)}});@else background-image: url({{asset('frontend/images/bg/px-1.jpg')}}); @endif">
    <div class="container">
        <div class="section-content">
            <div class="row">
                <div class="col-12">
                    <h4>{{isset($title)?$title:''}}</h4>
                    <p><a href="{{route('home')}}">{{__('Home')}}</a> <a>{{isset($title)?$title:''}}</a></p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Inner Section End -->

<section class="contact-details pb-70">
    <div class="container">
        <div class="section-content">
            <div class="row">
                <div class="col-12 col-sm-12 col-md-7 col-lg-7">
                    @if($contact_left?$contact_left->show:'')
                        {!! clean($contact_left->description) !!}
                        @if ($contact_left->form_title == 1)
                        <form id="ajax-contact" method="post" action="{{route('store-contact')}}">
                            @csrf
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <input type="text" name="f_name" id="name" class="form-control @error('f_name') is-invalid @enderror" placeholder="{{__('First Name')}}" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <input type="text" name="l_name" id="name2" class="form-control" placeholder="{{__('Last Name')}}" required>
                                </div>
                                <div class="form-group col-md-12">
                                    <input type="email" name="email" id="email" class="form-control" placeholder="{{__('Your Email')}}"  required>
                                </div>
                                <div class="form-group col-md-12">
                                    <input type="text" name="subject" class="form-control" placeholder="{{__('Subject')}}" id="subject" required>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="contact-textarea">
                                        <textarea class="form-control" rows="6" placeholder="{{__('Wright Message')}}" id="message" name="message" required></textarea>
                                        <button class="btn btn-theme mt-4" type="submit" value="Submit Form">{{__('Send
                                                Message')}}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        @endif
                    @endif
                </div>
                <div class="col-12 col-sm-12 col-md-5 col-lg-5">
                    @if($contact_right_heading?$contact_right_heading->show:'')
                        {!! clean($contact_right_heading->description) !!}
                    @endif
                    @if($contact?$contact->show:'')
                        <div class="service-item style-1 border-1px">
                            <div class="service-icon">
                                <i class="pe-7s-map"></i>
                            </div>
                            <div class="content">
                                <h5><a href="#">{{ clean($contact?$contact->title:'') }}</a></h5>
                                <p> {{ clean($contact?$contact->line_one:'')}}<br> {{ clean($contact?$contact->line_two:'')}}</p>
                            </div>
                        </div>
                    @endif
                    @if($businessInfo?$businessInfo->show:'')
                        <div class="service-item style-1 border-1px">
                            <div class="service-icon">
                                <i class="pe-7s-clock"></i>
                            </div>
                            <div class="content">
                                <h5><a href="#">{{__('Business Hours')}}</a></h5>
                                <p>{{ clean($businessInfo?$businessInfo->line_one:'')}}<br>{{ clean($businessInfo?$businessInfo->line_two:'')}}</p>
                            </div>
                        </div>
                    @endif
                    @if($emailInfo?$emailInfo->show:'')
                        <div class="service-item style-1 border-1px">
                            <div class="service-icon">
                                <i class="pe-7s-mail-open"></i>
                            </div>
                            <div class="content">
                                <h5><a href="#">{{__('Email')}}</a></h5>
                                <p>{{ clean($emailInfo?$emailInfo->line_one:'') }}<br>{{ clean($emailInfo?$emailInfo->line_two:'')}}</p>
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>
</section>

@endsection

@section('page-script')

@endsection
