@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($pageContent->bg_img))background-image: url({{ $pageContent->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif" data-type="parallax" data-speed="3">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? clean($title) : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? clean($title) : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Special Packages Section Start -->
    <section class="special-packages-sec pt-4 pb-60">
        <div class="container">
            <div class="card mb-4">
                <div class="card-body">
                    @if ($discount->images)
                        {!! imageShow($discount->images, 'Image', 'dicount-img', 'width="150"') !!}
                    @endif
                    <h3>{{ $discount->title }}</h3>
                    <p>{{ __('Discount Type: ') . discountType($discount->discount_type) }}</p>
                    <p>{{ __('Amount: ') . discountPriceShow($discount) }}</p>
                    <p>{{ __('Details: ') . $discount->details }}</p>
                </div>
            </div>
            @if ($package_list)
                <h4>{{ __('Packages') }}</h4><br>
                {!! $package_list !!}
            @endif
            @if ($hotel_list)
                <h4>{{ __('Hotels') }}</h4><br>
                {!! $hotel_list !!}
            @endif

        </div>
    </section>
    <!-- Special Packages Section End -->

@endsection

@section('page-script')
@endsection
