@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if(!empty($pageContent->bg_img))background-image: url({{asset($pageContent->bg_img)}});@else background-image: url({{asset('frontend/images/bg/px-1.jpg')}}); @endif">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{isset($title)?$title:''}}</h4>
                        <p><a href="{{route('home')}}">{{__('Home')}}</a> <a>{{isset($title)?$title:''}}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- faq Section Start -->
    <section class="faq-area">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    @foreach($faqs as $faq)
                    <div class="faq-col">
                        <div class="panel-group">
                            <h4 class="panel-title">{{clean($faq?$faq->question:'')}}</h4>
                            <div class="content">
                                <p>{{clean($faq?$faq->answer:'')}}</p>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    <!-- faq Section End -->
    <section class="text-center pt-0 pb-70">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    {{ $faqs->links('frontend.pagination.index') }}
                </div>
            </div>
        </div>
    </section>
@endsection

@section('page-script')

@endsection
