@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')
<link rel="stylesheet" href="{{ asset('frontend/nouislider/dist/nouislider.min.css') }}">
@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" data-type="parallax" data-speed="3" style="@if (!empty($pageContent->bg_img))background-image: url({{ $pageContent->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif">

        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? $title : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? $title : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Latest Hotel Section Start -->
    <section class="special-packages-sec pt-4 pb-60">
        <div class="container">
            <div class="list-size">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="card mb-4">
                            <div class="card-header bg-white p-2 px-3">
                                <h6 class="modal-title text-bold">{{ __('Search') }}</h6>
                            </div>
                            <div class="card-body p-2 px-3">
                                <form id="data_form" method="GET">
                                    @csrf
                                    <input type="hidden" name="page" id="page" value="1">

                                    <div class="form-group">
                                        <label for="" class="mb-1">{{ __('Country') }}</label>
                                        <select name="country_id" class="form-control">
                                            <option value="">{{ __('Select') }}</option>
                                            @foreach ($countries as $country)
                                                <option
                                                    {{ !empty($country_id) && $country_id == $country->id ? 'selected' : '' }}
                                                    value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="" class="mb-1">{{ __('City') }}</label>
                                        <select name="city_id" class="form-control" id="city_html">
                                            {!! $city_html !!}
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="" class="mb-1">{{ __('Person') }}</label>
                                        <div class="input-group">
                                            <select name="adult" id="" class="form-control">
                                                <option value="">{{ __('Adult') }}</option>
                                                @for ($ai = 1; $ai <= 4; $ai++)
                                                    <option {{ !empty($adult_person) && $adult_person == $ai ? 'selected' : '' }} value="{{ $ai }}">{{ $ai }}</option>
                                                @endfor
                                            </select>
                                            <select name="children" id="" class="form-control">
                                                <option value="">{{ __('Children') }}</option>
                                                @for ($ci = 1; $ci <= 4; $ci++)
                                                    <option {{ !empty($children_person) && $children_person == $ci ? 'selected' : '' }} value="{{ $ci }}">{{ $ci }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="">{{ __('Price') }}</label>
                                        <div id="steps-slider" class="mt-1"></div>
                                        <input type="hidden" id="min_price" name="min_price" value="{{ $min_price }}" />
                                        <input type="hidden" id="max_price" name="max_price" value="{{ $max_price }}" />
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-9" id="data_html">
                        {!! $list_view !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Latest Hotel Section End -->

@endsection

@section('page-script')
    @include('frontend.pages.hotel.script')
    @include('frontend.scripts.map-script')
@endsection
