@if ($hotels->count())
    <div class="row grid-mb">
        @foreach ($hotels as $hotel)
            @php
                $discount = $hotel->discount ? $hotel->discount->discount : null;
                $route = route('single-hotel', $hotel->id);
            @endphp
            <div class="col-lg-12">
                <div class="latest-hotel">
                    <div class="thumb">
                        <a href="{{ $route }}">
                            {!! imageShow(asset(UPLOAD_FOLDER_HOTELS.$hotel->feature_image), __('Feature Image'), '') !!}
                        </a>
                    </div>
                    <div class="content">
                        <a href="{{ $route }}">
                            <h4>{{ clean($hotel ? $hotel->hotel_name : '') }}</h4>
                        </a>
                        <h5>{{ Str::limit(clean($hotel ? $hotel->hotel_location : ''), 100) }}</h5>
                        <p>{{ Str::limit(clean($hotel ? $hotel->description : ''), 100) }}</p>
                        <a class="map-viw hotel_map" href="#hotel_map_modal" data-toggle="modal"
                            data-lat="{{ $hotel->latitude }}" data-lng="{{ $hotel->longitude }}"
                            data-name="{{ $hotel->hotel_name }}"><i
                                class="fa fa-map-marker"></i>{{ __('View on Map') }}</a>
                            @if ($hotel->price)
                                <p class="price">{{ __('One Night Price') }}: {{ currencyFormat($hotel->price) }}</p>
                            @endif
                        @if ($discount)
                            <h3>{{ __('Off') }}
                                <span>-{{ discountPriceShow($discount) }}</span>
                            </h3>
                        @endif
                        <div class="clearfix"></div>
                        <a class="btn-theme" href="{{ $route }}">
                            {{ __('View Deal') }}
                            <svg width="16" height="16" fill="currentColor" class="bi bi-chevron-right ml-1" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="row">
        <div class="col-md-12">
            @if ($hotels instanceof \Illuminate\Pagination\LengthAwarePaginator)
                {{ $hotels->links('frontend.pagination.index') }}
            @endif
        </div>
    </div>
    @include('frontend.pages.hotel.map-modal')
@else
    <div class="alert alert-warning text-center">
        <i class="fa fa-search fa-5x mb-3" aria-hidden="true"></i>
        <h4>{{ __('No hotel found') }}</h4>
    </div>
@endif
