@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')
    <link rel="stylesheet" href="{{ asset('frontend/css/images-grid.css') }}">
@endsection

@section('content')
    {{-- @dd($hotel) --}}
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($pageContent->bg_img))background-image: url({{ $pageContent->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif" data-type="parallax" data-speed="3">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? $title : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? $title : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Special Packages Section Start -->
    <section class="special-packages-sec pt-85 pb-60">
        <div class="container">
            <div class="row grid-mb">
                <div class="col-md-12">
                    <div class="special-packages dtl-st">
                        <div class="thumb">

                            {!! imageShow($hotel->hotel_primary_image, __('Hotel Image'), '') !!}
                            @if ($discount)
                                <div class="offer-price"> {{ __('Off') }} {{ discountPriceShow($discount) }}</div>
                            @endif

                            <div class="post-title-box">
                                <div class="price-box">
                                    <h5>{{ $hotel->hotelAccomodation ? discountPriceCalculate($hotel->hotelAccomodation->min('price'), $discount)['price'] : '' }}
                                    </h5>
                                    <h6>{{ __('Starts From') }}</h6>
                                </div>
                                <div class="title-box">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <h4>{{ clean($hotel ? $hotel->hotel_name : '') }}</h4>
                                            <h3>{{ clean($hotel ? $hotel->hotel_location : '') }}</h3>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="row">
                                                <div class="col-md-8 pt-2 ">
                                                    <h5 class="btn text-white pl-100"><i class="fa fa-share-alt pt-2 pb-2 text-danger"
                                                                                  data-toggle="dropdown" aria-expanded="false"></i>
                                                        <div class="dropdown-menu">
                                                            @include('frontend.share-link',['route'=>route('single-hotel', $hotel->id)])
                                                        </div>
                                                    </h5>
                                                </div>
                                                <div class="col-md-4 pt-2">
                                                    <a class="btn btn-primary scroll_to_div" data-id="accommodation_section"
                                                       href="javascipt:void()">{{ __('Booking Now') }}</a>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="content">
                            <ul class="info">
                                <div class="row">
                                <div class="col-md-6">
                                    <li>{{ $hotel->hotel_location }}</li>
                                </div>
                                <div class="col-md-6 text-right">
                                    <li><a class="hotel_map" href="#hotel_map_modal" data-toggle="modal"
                                           data-lat="{{ $hotel->latitude }}" data-lng="{{ $hotel->longitude }}"
                                           data-name="{{ $hotel->hotel_name }}"><i class="fa fa-map-marker"></i>
                                            {{ __('View on Map') }}</a></li>
                                </div>
                                </div>
                            </ul>
                            <p>{{ clean($hotel ? $hotel->description : '') }}</p>

                            <div class="small-hotel">
                                <div id="gallery"></div>
                            </div>

                            <div class="inner-title mt-25">
                                <h2>{{ clean($hotel?$hotel->hotel_to_stay_title:'') }}</h2>
                                <div class="sec-line mb-15"></div>
                                <p>{{ clean($hotel?$hotel->hotel_to_stay_description:'') }}</p>
                            </div>
                            <div class="inner-title mt-25">
                                <div class="row">
                                    <div class="col-md-4">
                                        <h2>{{ __('Brackfast Info') }}</h2>
                                        <div class="sec-line mb-15"></div>
                                        <p>{{ clean($hotel?$hotel->breakfast_info:'') }}</p>
                                    </div>
                                    <div class="col-md-4">
                                        <h2>{{ __('Lunch Info') }}</h2>
                                        <div class="sec-line mb-15"></div>
                                        <p>{{ clean($hotel?$hotel->lunch_info:'') }}</p>
                                    </div>
                                    <div class="col-md-4">
                                        <h2>{{ __('Dinner Info') }}</h2>
                                        <div class="sec-line mb-15"></div>
                                        <p>{{ clean($hotel?$hotel->dinner_info:'') }}</p>
                                    </div>
                                </div>

                            </div>
                            <div class="inner-title mt-25">
                                <h2>{{ __('Facilities') }}</h2>
                                <div class="sec-line mb-15"></div>
                                <ul>
                                    @foreach (getFacilities($hotel->facilities) as $facility)
                                        <li>{{ $facility }}</li>
                                    @endforeach
                                </ul>
                            </div>

                            <div class="inner-title mt-25" id="accommodation_section">
                                <h2>{{ __('Accommodation') }}</h2>
                                <div class="sec-line mb-15"></div>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>{{ __('Room Type') }}</th>
                                            <th width="10%">{{ __('Sleeps') }}</th>
                                            <th width="12%">{{ __('Today\'s Price') }}</th>
                                            <th width="15%">{{ __('Booking') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($hotel_accommodations as $hotel_accommodation)
                                            <tr>
                                                <td>
                                                    <h3 class="mb-0">
                                                        <a href="#hotel_images_modal" data-toggle="modal"
                                                            data-url="{{ route('hotel-accommodation-image', $hotel_accommodation->id) }}"
                                                            data
                                                            class="accommodation_images">{{ $hotel_accommodation->accommodation->name }}</a>
                                                    </h3>
                                                    @php
                                                        $h_a_facilities = getFacilities($hotel_accommodation->facilities);
                                                    @endphp
                                                    <h6 class="mb-0">{{ __('Facilities:') }}</h6>
                                                    <ul>
                                                        @foreach ($h_a_facilities as $h_a_facility)
                                                            <li class="singleFacility">
                                                                {{ $h_a_facility }}</li>
                                                        @endforeach
                                                    </ul>
                                                </td>
                                                <td>
                                                    {{ $hotel_accommodation->no_of_adult . __(' Adult') }} <br />
                                                    {{ $hotel_accommodation->no_of_children . __(' Children') }}
                                                </td>
                                                <td class="text-center">{{ discountPriceCalculate($hotel_accommodation->price, $discount)['price'] }}
                                                </td>
                                                <td>
                                                    <a class="btn-theme"
                                                        href="{{ route('booking.hotel', ['hotel_id' => $hotel->id, 'accommodation_id' => $hotel_accommodation->id]) }}">{{ __('Booking Now') }}</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Special Packages Section End -->


    @if ($page_client_say)
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="inner-title mt-25">
                            <h2>{{ clean($page_client_say ? $page_client_say->title : '') }}</h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide owl-carousel owl-theme owl-navst st-three">
                            @foreach ($page_client_say_testimonials as $testimonial)
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        {!! imageShow($testimonial->image, 'Client Photo') !!}
                                    </div>
                                    <div class="content">
                                        <h5>{{ clean($testimonial ? $testimonial->name : '') }} <small>-
                                                {{ clean($testimonial ? $testimonial->designation : '') }}</small></h5>
                                        {!! ratingShow($testimonial->rating) !!}
                                        <p><i class="fa fa-quote-left"></i>
                                            {{ clean($testimonial ? $testimonial->testimonial : '') }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    @endif



    <div class="modal fade" id="hotel_images_modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="hotel_images_modal_title"></h5>
                    <button type="button" class="btn btn-close" data-dismiss="modal" aria-label="Close"><i
                            class="fa fa-times"></i></button>
                </div>
                <div class="modal-body" id="hotel_images">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('Close') }}</button>
                </div>
            </div>
        </div>
    </div>

    @include('frontend.pages.hotel.map-modal')
@endsection

@section('page-script')
    @include('frontend.scripts.gallery-js')
    @include('frontend.scripts.map-script')
    @include('frontend.pages.hotel.image-script')
@endsection
