@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
<!-- Inner Section Start -->
<section class="inner-area parallax-bg"
    style="@if (!empty($pageContent->bg_img))background-image: url({{ $pageContent->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif"
    data-type="parallax" data-speed="3">
    <div class="container">
        <div class="section-content">
            <div class="row">
                <div class="col-12">
                    <h4>{{ isset($title) ? clean($title) : '' }}</h4>
                    <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                        <a>{{ isset($title) ? clean($title) : '' }}</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Inner Section End -->

<!-- Special Packages Section Start -->
<section class="special-packages-sec pt-85 pb-60">
    <div class="container">
        <div class="row grid-mb">
            <div class="col-md-12">
                <div class="special-packages dtl-st">
                    <div class="thumb">
                        @if (count($package->images))
                        {!! imageShow($package->images[0]->images, __('Tour Image'), '') !!}
                        @endif

                        @if ($discount)
                        <div class="offer-price"> {{ __('Off') }} {{ discountPriceShow($discount) }}</div>
                        @endif
                        <div class="post-title-box">
                            <div class="price-box">
                                <h5>{{ $sub_price ? discountPriceCalculate($sub_price[0]->tour_price, $discount)['price'] :
                                    'Unknown' }}
                                </h5>
                                <h6>{{ __('Starts From') }}</h6>
                            </div>
                            <div class="title-box">
                                <div class="row">
                                    <div class="col-md-8">
                                        <h4>{{ clean($package?$package->title:'') }}</h4>
                                        <h3>{{ clean($package?$package->location:'') }}</h3>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="col-md-8 pt-2">
                                                <h5 class="btn text-white pl-100"><i
                                                        class="fa fa-share-alt pt-2 pb-2 text-danger"
                                                        data-toggle="dropdown" aria-expanded="false"></i>
                                                    <div class="dropdown-menu">
                                                        @include('frontend.share-link',['route'=>route('package.details',
                                                        $package->id)])
                                                    </div>
                                                </h5>
                                            </div>
                                            <div class="col-md-4 pt-2">
                                                <a class="btn btn-primary scroll_to_div" data-id="group_price_section"
                                                    href="javascipt:void()">{{ __('Booking Now') }}</a>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="content">
                        <ul class="info">
                            <li><a><i class="fa fa-calendar"></i>{{ $package->day }}
                                    {{ __('Days') }}</a></li>
                            <li><a><i class="fa fa-user"></i>{{ $sub_price ? $sub_price[0]->group_size : '' }}</a>
                            </li>
                            @if ($package->tour_map_image)
                            <li><a class="package_map" href="#package_map_modal" data-toggle="modal"
                                    data-name="{{ $package->title }}"
                                    data-image="{{ imageShow($package->tour_map_image, 'Package Image') }}"><i
                                        class="fa fa-map-marker"></i>{{ __('View Map Image') }}</a>
                            </li>
                            @endif
                        </ul>
                        <p>{{ $package->description }}</p>
                        <div class="row">
                            @foreach ($package->images as $image)
                            <div class="col-md-6">
                                {!! imageShow($image->images, __('Tour Image'), '') !!}
                            </div>

                            @endforeach
                        </div>
                        <div class="inner-title mt-25">
                            <h2>{{ __('Tour Highlight') }}</h2>
                            <div class="mb-40">{{ clean($package?$package->tour_highlight:'') }}</div>
                        </div>
                        <div class="inner-title mt-25">
                            <h2>{{ __('Tour Itineraries') }}</h2>
                            <div class="mb-40">{{ clean($package?$package->tour_itineraries:'') }}</div>
                        </div>

                        @php
                        $map_iamge = imageShow($package->tour_map_image, __('Tour Map Image'), 'mw-50');
                        @endphp

                        @if ($map_iamge)
                        <div class="inner-title mt-25">
                            <h2>{{ __('Tour Map') }}</h2>
                            <div class="mb-40">
                                {!! $map_iamge !!}
                            </div>
                        </div>
                        @endif

                        <div class="inner-title mt-25" id="group_price_section">
                            <h2>{{ __('Sub Price') }}</h2>
                            <div class="mb-40">
                                <table class="table table-striped  table-bordered">
                                    <thead>
                                        <tr>
                                            <th>{{ __('Group Size') }}</th>
                                            <th width="12%">{{ __('Price') }}
                                                @if ($discount)
                                                <span class="small mt-0">{{ __('(Discounted)') }}</span>
                                                @endif
                                            </th>
                                            <th width="16%">{{ __('Booking') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($sub_price as $price)
                                        <tr>
                                            <td class="pt-4 pl-4">{{ $price->group_size }}</td>
                                            <td class="text-center pt-4">{{ discountPriceCalculate($price->tour_price, $discount)['price'] }}</td>
                                            <td>
                                                <a class="btn-theme"
                                                    href="{{ route('booking.package', ['package_id' => $package->id, 'group_id' => $price->id]) }}">{{
                                                    __('Booking Now') }}</a>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="inner-title mt-25">
                            <h2>{{ __('Inclusion and Exclusion') }}</h2>
                            <h4>{{ __('Inclusion') }}</h4>
                            <div class="mb-40 ml-4">{!! clean($package?$package->inclusion:'') !!} </div>
                            <h4>{{ __('Exclusion') }}</h4>
                            <div class="mb-40 ml-4">{!! clean($package?$package->exclusion:'') !!} </div>
                        </div>
                        <div class="inner-title mt-25">
                            <h2>{{ __('Important notes') }}</h2>
                            <div class="mb-40 ml-4">{!! clean($package?$package->notes:'') !!} </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Special Packages Section End -->

@if($latestPackage)
<!-- Global Section Start -->
<section class="global-section over-layer-white pt-10 pb-70">

    <div class="container">
        <div class="inner-title mt-25 text-center pb-20">
            <h2>{{ __('Latest Packages') }}</h2>
            <p>{{__('Here you choose your place that\'s special and you want to go')}}</p>
        </div>
        <div class="row">
            <div class=" specialplaces_carousel owl-carousel owl-theme owl-navst st-two">
                @foreach ($latestPackage as $place_package)
                @php
                $discount = $place_package->discount ? $place_package->discount->discount : null;
                $subprices = $place_package->subprice ? $place_package->subprice : null;
                @endphp
                <div class="item">
                    <div class="special-places">
                        @if (count($place_package->images))
                        <div class="thumb">
                            {!! imageShow($place_package->images[0]->images, 'upload/pkg_image/', __('Tour Image'), '')
                            !!}
                        </div>
                        @endif

                        <div class="content">
                            <div class="price-box">
                                <h5>{{ $subprices[0] ? discountPriceCalculate($subprices[0]->tour_price, $discount)['price'] : ''
                                    }}
                                </h5>
                                </h5>
                                <h6>{{ __('Starts From') }}</h6>
                            </div>
                            <div class="title-box">
                                <h4>{{ $place_package->title }}</h4>
                                <h3>{{ $place_package->location }}</h3>
                            </div>
                            <ul class="info">
                                <li><span><i class="fa fa-calendar"></i>{{ $place_package->day }}
                                        {{ __('Days') }}</span>
                                </li>
                                <li><span><i class="fa fa-user"></i>{{ $subprices && $subprices[0] ?
                                        $subprices[0]->group_size : '' }}</span>
                                </li>
                                @if ($place_package->tour_map_image)
                                <li><a class="package_map" href="#package_map_modal" data-toggle="modal"
                                        data-name="{{ $place_package->title }}"
                                        data-image="{{ imageShow($place_package->tour_map_image, 'Package Image') }}"><i
                                            class="fa fa-map-marker"></i>{{ __('View Map Image') }}</a>
                                </li>
                                @endif
                            </ul>
                            <p>{{ clean(Str::limit($place_package ? $place_package->description : '',135)) }}
                            </p>
                            <h5 class="share-btn"><i class="fa fa-share-alt" data-toggle="dropdown"
                                    aria-expanded="false"></i>
                                <div class="dropdown-menu">
                                    @include('frontend.share-link',['route'=>route('package.details',
                                    $place_package->id)])
                                </div>
                            </h5>
                            <a class="btn-theme" href="{{ route('package.details', $place_package->id) }}">{{ __('View
                                Details') }}</a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

        </div>
    </div>
</section>
<!-- Global Section End -->

@endif


@include('frontend.pages.packages.map-image-modal')
@endsection

@section('page-script')
<script src="{{ asset('frontend/js/jquery.fancybox.js') }}"></script>
@include('frontend.scripts.package-map-script')
@endsection