@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
@endsection
@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($pageContent->bg_img))background-image: url({{ $pageContent->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif" data-type="parallax" data-speed="3">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? clean($title) : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a> <a>{{ isset($title) ? clean($title) : '' }}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->
    <!-- Special Packages Section Start -->
    <section class="special-places-sec pb-50">
        <div class="container">
            <div class="row grid-mb">
                @foreach ($places as $place)
                    <div class="col-lg-4 col-md-6">
                        <div class="special-places">
                            <div class="thumb">
                                <img src="{{ asset('upload/places/' . $place->place_primary_image) }}" alt="">
                            </div>
                            <div class="content text-center">
                                    <h4>
                                        <a class="btn-theme float-none"
                                        href="{{ route('package', $place->id, PACKAGE_PAGE_TYPE_PLACE) }}">{{ $place->name }}</a>
                                    </h4>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="page-link-item text-center pt-30 pb-20">

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Special Packages Section End -->

    @if ($left_package || $right_package_img)
        <!-- Global Section Start -->
        <section class="global-section over-layer-white pt-80 pb-70">
            <div class="container">
                <div class="row">
                    @if ($left_package)
                        <div class="col-xl-7 col-lg-12">
                            <div class="global-area">
                                <div class="inner-title">
                                    <h2>{{ clean($left_package ? $left_package->title : '') }}</h2>
                                    <h3>{{ clean($left_package ? $left_package->sub_title : '') }}</h3>
                                    <div class="sec-line"></div>
                                </div>
                                {!! clean($left_package ? $left_package->description : '') !!}
                            </div>
                        </div>
                    @endif
                    @if ($right_package_img)
                        <div class="col-xl-5 col-lg-8 col-md-10">
                            @if ($right_package_img && $right_package_img->fnt_img)
                                <div class="map-area">
                                    {!! imageShow($right_package_img->fnt_img, __('Image')) !!}
                                </div>
                            @endif
                            <p class="map-content">
                                {{ clean($right_package_img ? $right_package_img->about_image_phone : '') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </section>
        <!-- Global Section End -->
    @endif

    @if ($testimonial_setting)
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="inner-title mt-25">
                            <h2>{{ clean($testimonial_setting ? $testimonial_setting->title : '') }}</h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide owl-carousel owl-theme owl-navst st-three">
                            @foreach ($testimonials as $testimonial)
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        <img src="{{ asset('/upload/testimonial/' . $testimonial->image) }}" alt="">
                                    </div>
                                    <div class="content">
                                        <h5>{{ clean($testimonial ? $testimonial->name : '') }} <small>-
                                                {{ clean($testimonial ? $testimonial->designation : '') }}</small></h5>
                                        {!! ratingShow($testimonial->rating) !!}
                                        <p><i class="fa fa-quote-left"></i>
                                            {{ clean($testimonial ? $testimonial->testimonial : '') }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    @endif
@endsection
@section('page-script')
@endsection
