@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
    <!-- Slick Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($pageContent->bg_img))background-image: url({{ $pageContent->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? clean($title) : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? clean($title) : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Slick Section End -->

    <!-- Testimonials Section Start -->
    <section class="testimonials-section pt-80 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="inner-title mt-25">
                        <h2>{{ clean($pageContent ? $pageContent->title : '') }}</h2>
                        <div class="sec-line mb-40"></div>
                    </div>
                    <div class="testimonials-post testimonials_slide owl-carousel owl-theme owl-navst st-three">
                        @foreach ($testimonials as $testimonial)
                            <div class="testimonials-item">
                                <div class="thumb">
                                    {!! imageShow($testimonial->image, __('Client Photo')) !!}
                                </div>
                                <div class="content">
                                    <h5>{{ clean($testimonial ? $testimonial->name : '') }} <small>-
                                            {{ clean($testimonial ? $testimonial->designation : '') }}</small></h5>
                                    {!! ratingShow($testimonial->rating) !!}
                                    <p><i class="fa fa-quote-left"></i> {!! clean($testimonial ? $testimonial->testimonial : '') !!}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Testimonials Section End -->

    @if ($pagePromotion)
        <!-- App Section Start -->
        <section class="app-section over-layer-white pt-80 pb-90" style="@if (!empty($pagePromotion->bg_img))background-image: url({{ $pagePromotion->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif">
            <div class="container">
                <div class="row">
                    <div class="col-lg-10 offset-lg-1">
                        <div class="inner-title title-center">
                            <h2>{{ clean($pagePromotion ? $pagePromotion->title : '') }}</h2>
                            <h3>{{ clean($pagePromotion ? $pagePromotion->sub_title : '') }}</h3>
                            <div class="sec-line line-center"></div>
                        </div>
                        <p>{{ clean($pagePromotion ? $pagePromotion->description : '') }}</p>
                        <a class="btn-theme"
                            href="{{ clean($pagePromotion ? $pagePromotion->btn_1_url : '') }}">{{ clean($pagePromotion ? $pagePromotion->btn_1 : '') }}</a>
                        <a class="btn-theme btn-two"
                            href="{{ clean($pagePromotion ? $pagePromotion->btn_2_url : '') }}">{{ clean($pagePromotion ? $pagePromotion->btn_2 : '') }}</a>
                    </div>
                </div>
            </div>
        </section>
        <!-- App Section End -->
    @endif



@endsection

@section('page-script')

@endsection
