@if ($generalSetting && $generalSetting->google_map_api_key)
<script src="https://maps.googleapis.com/maps/api/js?key={{$generalSetting->google_map_api_key}}&v=weekly&channel=2" async></script>
@else 
<script src="https://maps.googleapis.com/maps/api/js?v=weekly&channel=2" async></script>    
@endif

<script>
    (function($) {
        "use strict";

        $(document.body).on('click', '.hotel_map', function() {
            let lat = parseFloat($(this).data('lat'));
            let lng = parseFloat($(this).data('lng'));
            let hotel_name = $(this).data('name');

            const HotelLatLng = {
                lat: lat,
                lng: lng
            };
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 18,
                center: HotelLatLng,
            });

            new google.maps.Marker({
                position: HotelLatLng,
                map,
                title: hotel_name,
            });

            $('#hotel_map_modal_title').html(hotel_name)
        })

    })(jQuery);
</script>
