@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
    <!-- Slick Section Start -->
    @if ($slider_setting)
        <section class="slider-wrapper st-two p-0">
            <div id="slider-style-one" class="carousel slide bs-slider control-round indicators-line" data-ride="carousel"
                data-pause="hover" data-interval="5000">
                <!-- Indicators -->
                <ol class="carousel-indicators">
                    @for ($i = 0; $i < count($sliders); $i++)
                        <li data-target="#slider-style-one" data-slide-to="{{ $i }}" @if ($i == 0) class="active" @endif>
                        </li>
                    @endfor
                </ol>
                <!-- Wrapper For Slides -->
                <div class="carousel-inner" role="listbox">
                    @foreach ($sliders as $skey => $slider)
                        <!-- Item Slide -->
                        <div class="carousel-item {{ $skey == 0 ? 'active' : '' }}">

                            <!-- Slide Background -->
                            {!! imageShow($slider->bg_image, 'Slider Images', 'slide-image') !!}
                            <div class="bs-slider-overlay"></div>
                            <div class="container">
                                <div class="row">
                                    <!-- Slide Text Layer -->
                                    <div class="slide-text slide-style-left st-two">
                                        <h1>{{ clean($slider ? $slider->title : '') }}</h1>
                                        <h2>{{ clean($slider ? $slider->sub_title : '') }}</h2>
                                    </div>
                                    <!-- Package Box -->
                                    <div class="package-box">
                                        {!! $slider->description !!}
                                        <a href="{{ $slider->button_url }}">{{ $slider->button_name }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    <!-- End of Slide -->
                </div><!-- End of Wrapper For Slides -->
                <!-- Left Control -->
                <a class="left carousel-control" href="#slider-style-one" role="button" data-slide="prev">
                    <span class="fa fa-angle-left" aria-hidden="true"></span>
                    <span class="sr-only">{{ __('Previous') }}</span>
                </a>
                <!-- Right Control -->
                <a class="right carousel-control" href="#slider-style-one" role="button" data-slide="next">
                    <span class="fa fa-angle-right" aria-hidden="true"></span>
                    <span class="sr-only">{{ __('Next') }}</span>
                </a>
            </div> <!-- End  slider-style-one Slider -->
        </section>
        <!-- Slick Section End -->
    @endif
    <!-- Welcome Section Start -->
    @if ($slider_setting)
    <section class="welcome-section">
        <div class="container">
            {!! $slider_setting?$slider_setting->description:'' !!}
        </div>
    </section>
    @endif
    <!-- Welcome Section End -->

    <!-- Special Places Section Start -->
    @if ($place_setting && count($places))
        <section class="special-places-sec pb-80">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        @if ($place_setting->title)<h4>{{ clean($place_setting->title) }}</h4>@endif
                        @if ($place_setting->sub_title)<h2>{{ clean($place_setting->sub_title) }}</h2>@endif
                        @if ($place_setting->description)<p>{{ clean($place_setting->description) }}</p>@endif
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="tab-style">
                            <nav>
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                    @if (count($places))
                                        @foreach ($places as $pkey => $place)
                                            <a class="nav-item nav-link {{ $pkey == 0 ? 'active' : '' }}"
                                                id="plc-{{ $place->id }}-tab" data-toggle="tab"
                                                href="#plc-{{ $place->id }}" role="tab"
                                                aria-controls="plc-{{ $place->id }}"
                                                aria-selected="true">{{ $place->name }}</a>
                                        @endforeach
                                    @endif
                                </div>
                            </nav>
                            <div class="tab-content" id="nav-tabContent">
                                <!-- item start -->
                                @if (count($places))
                                    @foreach ($places as $pakey => $place)
                                        <div class="tab-pane fade {{ $pakey == 0 ? 'show active' : '' }}"
                                            id="plc-{{ $place->id }}" role="tabpanel"
                                            aria-labelledby="plc-{{ $place->id }}-tab">
                                            <div class="specialplaces_carousel owl-carousel owl-theme owl-navst st-two">
                                                @foreach ($place->package as $place_package)
                                                    @php
                                                        $discount = $place_package->discount ? $place_package->discount->discount : null;
                                                        $subprices = $place_package->subprice ? $place_package->subprice : null;
                                                    @endphp
                                                    <div class="item">
                                                        <div class="special-places">
                                                            @if (count($place_package->images))
                                                                <div class="thumb">
                                                                    <a href="{{ route('package.details', $place_package->id) }}">
                                                                        {!! imageShow($place_package->images[0]->images, 'upload/pkg_image/', __('Tour Image'), '') !!}
                                                                    </a>
                                                                </div>
                                                            @endif

                                                            <div class="content">
                                                                <div class="price-box">
                                                                    <h5>{{ currencyFormat($place_package->price) }}
                                                                    </h5>
                                                                    <h6>{{ __('Starts From') }}</h6>
                                                                </div>
                                                                <div class="title-box">
                                                                    <h4><a href="{{ route('package.details', $place_package->id) }}">{{ Str::limit($place_package->title, 50) }}</a></h4>
                                                                    <h3>{{ $place_package->location }}</h3>
                                                                </div>
                                                                <ul class="info">
                                                                    <li><span><i
                                                                                class="fa fa-calendar"></i>{{ $place_package->day }}
                                                                            {{ __('Days') }}</span>
                                                                    </li>
                                                                    <li><span><i
                                                                                class="fa fa-user"></i>{{ $subprices && $subprices[0] ? $subprices[0]->group_size : '' }}</span>
                                                                    </li>
                                                                    @if ($place_package->tour_map_image)
                                                                        <li><a class="package_map"
                                                                                href="#package_map_modal"
                                                                                data-toggle="modal"
                                                                                data-name="{{ $place_package->title }}"
                                                                                data-image="{{ imageShow($place_package->tour_map_image, 'Package Image') }}"><i
                                                                                    class="fa fa-map-marker"></i>{{ __('View Map Image') }}</a>
                                                                        </li>
                                                                    @endif
                                                                </ul>
                                                                <p>{{ clean(Str::limit($place_package ? $place_package->description : '',135)) }}
                                                                </p>
                                                                <h5 class="share-btn"><i class="fa fa-share-alt"
                                                                        data-toggle="dropdown" aria-expanded="false"></i>
                                                                    <div class="dropdown-menu">
                                                                        @include('frontend.share-link',['route'=>route('package.details', $place_package->id)])
                                                                    </div>
                                                                </h5>
                                                                <a class="btn-theme"
                                                                    href="{{ route('package.details', $place_package->id) }}">{{ __('View Details') }}</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                                <!-- item end -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Special Places Section End -->
    @endif

    @if ($feature_setting && count($features))
        <!-- Features Section Start -->
        <section class="feature-section over-layer-black pt-85 pb-90" @if ($feature_setting && $feature_setting->fnt_img) style="background-image: url('{{ $feature_setting->fnt_img }}')"  @endif>
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4>{{ clean($feature_setting ? $feature_setting->title : '') }}</h4>
                        <h2>{{ clean($feature_setting ? $feature_setting->sub_title : '') }}</h2>
                        <p>{{ clean($feature_setting ? $feature_setting->description : '') }}</p>
                    </div>
                </div>
                <div class="row">
                    @foreach ($features as $feature)
                        <div class="col-md-4">
                            <div class="feature-item">
                                <div class="icon-box">
                                    {!! clean($feature ? $feature->icon : '') !!}
                                </div>
                                <div class="content">
                                    <h3>{{ clean($feature ? $feature->title : '') }}</h3>
                                    <p>{{ clean($feature ? $feature->description : '') }}</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- Feature Section End -->
    @endif

    @if ($spacial_package_setting && count($spacial_packages))
        <!-- Special Packages Section Start -->
        <section class="special-packages-sec pt-85 pb-90">
            <div class="container">
                <div class="row">
                    <div class="col-md-9">
                        <div class="section-title stitle-left">
                            <h4>{{ clean($spacial_package_setting ? $spacial_package_setting->title : '') }}</h4>
                            <h2>{{ clean($spacial_package_setting ? $spacial_package_setting->sub_title : '') }}</h2>
                            <p>{{ clean($spacial_package_setting ? $spacial_package_setting->description : '') }}</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="@if ($spacial_package_discount) col-lg-9 @else col-lg-12 @endif">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="specialpackages_carousel owl-carousel owl-theme owl-navst">
                                    @foreach ($spacial_packages as $spacial_package)
                                        @php
                                            $discount = $spacial_package->discount ? $spacial_package->discount->discount : null;
                                            $subprices = $spacial_package->subprice ? $spacial_package->subprice : null;
                                            $package_images = $spacial_package->images;
                                        @endphp
                                        <div class="item">
                                            <div class="special-packages">
                                                <div class="thumb">
                                                    @if (count($package_images))
                                                    <a href="{{ route('package.details', $spacial_package->id) }}">
                                                        {!! imageShow($package_images[0]->images, __('Tour Image'), '') !!}
                                                    </a>
                                                    @endif

                                                    @if ($discount)
                                                        <div class="offer-price"> {{ __('Off') }}
                                                            {{ discountPriceShow($discount) }}
                                                        </div>
                                                    @endif

                                                    <div class="post-title-box">
                                                        <div class="price-box">
                                                            <h5>{{ currencyFormat($spacial_package->price) }}
                                                            </h5>
                                                            <h6>{{ __('Starts From') }}</h6>
                                                        </div>
                                                        <div class="title-box">
                                                            <a href="{{ route('package.details', $spacial_package->id) }}">
                                                                <h4>
                                                                    {{ Str::limit($spacial_package->title, 50) }}
                                                                </h4>
                                                            </a>
                                                            <h3>{{ $spacial_package->location }}</h3>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="content">
                                                    <ul class="info">
                                                        <li><span><i
                                                                    class="fa fa-calendar"></i>&nbsp;{{ $spacial_package->day }}
                                                                {{ __('Days') }}</span></li>
                                                        <li><span><i
                                                                    class="fa fa-user"></i>&nbsp;{{ $subprices && $subprices[0] ? $subprices[0]->group_size : '' }}</span>
                                                        </li>
                                                        @if ($spacial_package->tour_map_image)
                                                            <li><a class="package_map" href="#package_map_modal"
                                                                    data-toggle="modal"
                                                                    data-name="{{ $spacial_package->title }}"
                                                                    data-image="{{ imageShow($spacial_package->tour_map_image, 'Package Image') }}"><i
                                                                        class="fa fa-map-marker"></i>{{ __('View Map Image') }}</a>
                                                            </li>
                                                        @endif
                                                    </ul>
                                                    <p>{{ clean(Str::limit($spacial_package->description,135)) }}</p>
                                                    <div class="small-hotel">

                                                        <div class="thumb">
                                                            @if ($package_images)
                                                                @foreach ($package_images as $image)
                                                                    {!! imageShow($image->images, __('Tour Image'), '') !!}&nbsp;
                                                                @endforeach
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <h5 class="share-btn"><i class="fa fa-share-alt"
                                                            data-toggle="dropdown" aria-expanded="false"></i>
                                                        <div class="dropdown-menu">
                                                            @include('frontend.share-link',['route'=>route('package.details', $spacial_package->id)])
                                                        </div>
                                                    </h5>
                                                    <a class="btn-theme"
                                                        href="{{ route('package.details', $spacial_package->id) }}">{{ __('View Details') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    @if ($spacial_package_discount)
                        <div class="col-lg-3">
                            <div class="add-box thumb">
                                <a href="{{ route('discount.details', $spacial_package_discount->id) }}">
                                    {!! imageShow($spacial_package_discount->images, __('Discount'), '') !!}
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </section>
        <!-- Special Packages Section End -->
    @endif

    @if ($award_setting)
        <!-- Funfact Section Start -->
        <section class="funfact-section over-layer-black pt-90 pb-60">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="video-sec">
                            <h2>{{ clean($award_setting ? $award_setting->title : '') }}</h2>
                            <p>{{ clean($award_setting ? $award_setting->sub_title : '') }}</p>
                            <div class="video-content">
                                {!! imageShow($award_setting->fnt_img, __('Award Image')) !!}
                                @if ($award_setting->youtube_url)
                                    <div class="overlay">
                                        <a href="{{ $award_setting->youtube_url }}" class="popup-youtube"><i
                                                class="ficon fa fa-play-circle"></i></a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        {!! clean($award_setting ? $award_setting->description : '') !!}
                    </div>
                </div>
            </div>
        </section>
        <!-- Funfact Section End -->
    @endif


    @if ($hotel_setting)
        <!-- Latest Hotel Section Start -->
        <section class="latest-hotel-sec pt-85 pb-80">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4>{{ clean($hotel_setting ? $hotel_setting->title : '') }}</h4>
                        <h2>{{ clean($hotel_setting ? $hotel_setting->sub_title : '') }}</h2>
                        <p>{{ clean($hotel_setting ? $hotel_setting->description : '') }}</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="latesthotel_carousel owl-carousel owl-theme owl-navst">
                            @foreach ($hotels as $hotel)
                                <div class="item">
                                    <div class="latest-hotel">
                                        <div class="thumb">
                                            <a href="{{ route('single-hotel', $hotel->id) }}">
                                                {!! imageShow(asset(UPLOAD_FOLDER_HOTELS.$hotel->feature_image), __('Hotel Image')) !!}
                                            </a>
                                        </div>
                                        <div class="content">
                                            <a href="{{ route('single-hotel', $hotel->id) }}">
                                                <h4>{{ clean($hotel ? $hotel->hotel_name : '') }}</h4>
                                            </a>
                                            <h5>{{ clean(Str::limit($hotel ? $hotel->hotel_location : '',40)) }}</h5>
                                            <p>{{ Str::limit(clean($hotel ? $hotel->description : ''), 70) }}</p>
                                            <a class="map-viw hotel_map" href="#hotel_map_modal" data-toggle="modal"
                                                data-lat="{{ $hotel->latitude }}" data-lng="{{ $hotel->longitude }}"
                                                data-name="{{ $hotel->hotel_name }}"><i
                                                    class="fa fa-map-marker"></i>{{ __('View on Map') }}</a>
                                                @if ($hotel->price)
                                                    <p class="price">{{ __('One Night Price') }}: {{ currencyFormat($hotel->price) }}</p>
                                                @endif
                                            <a class="btn-theme"
                                               href="{{ route('single-hotel', $hotel->id) }}">{{ __('Book now') }}</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        @include('frontend.pages.hotel.map-modal')
        <!-- Latest Hotel Section End -->
    @endif

    @if ($about_setting)
        <!-- Global Section Start -->
        <section class="global-section over-layer-white pt-80 pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-xl-7 col-lg-12">
                        <div class="global-area">
                            <div class="inner-title">
                                <h2>{{ clean($about_setting ? $about_setting->title : '') }}</h2>
                                <h3>{{ clean($about_setting ? $about_setting->sub_title : '') }}</h3>
                                <div class="sec-line"></div>
                            </div>
                            {!! clean($about_setting ? $about_setting->description : '') !!}
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-8 col-md-10">
                        @if ($about_setting && $about_setting->fnt_img)
                            <div class="map-area">
                                {!! imageShow($about_setting->fnt_img, __('Image')) !!}
                            </div>
                        @endif
                        <p class="map-content">{{ clean($about_setting ? $about_setting->about_image_phone : '') }}
                        </p>
                    </div>
                </div>
            </div>
        </section>
        <!-- Global Section End -->
    @endif


    @if ($gallery_setting)
        <!-- Gallery Section Start -->
        <section class="gallery-section pt-85 pb-0">
            <div class="container-fluid">
                <div class="row">
                    <div class="section-title">
                        <h4>{{ clean($gallery_setting ? $gallery_setting->title : '') }}</h4>
                        <h2>{{ clean($gallery_setting ? $gallery_setting->sub_title : '') }}</h2>
                        <p>{{ clean($gallery_setting ? $gallery_setting->description : '') }}</p>
                    </div>
                </div>
                <div class="row gallery-items">
                    @foreach ($galleries as $gallery)
                        <div class="col-sm-4 col-grid">
                            <div class="gallery-item">
                                <div class="thumb">
                                    {!! imageShow($gallery->image, __('Image')) !!}
                                    <div class="overlay">
                                        <div class="inner">
                                            <a href="{{ $gallery->image }}" class="icon lightbox-image">
                                                <i class="fa fa-plus"></i>
                                            </a>
                                            <h4>{{ clean($gallery ? $gallery->title : '') }}</h4>
                                            <p>{{ __('Tour, Travel') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- Gallery Section End -->
    @endif


    @if ($testimonial_setting)
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    @if (isset($left_side_testimonial))
                    <div class="col-lg-5">
                        <div class="testimonial-video mt-0">
                            <h5 style="font-family: Lora, Bangla304, serif;">{{ __('Latest Hotel Reviews') }}</h5>
                            <div class="sec-line mb-20"></div>
                            <h3 style="font-family: Lora, Bangla304, serif;"><i class="fa fa-quote-left" style="font-family: FontAwesome, Bangla304, sans-serif;"></i> {{ Str::words($left_side_testimonial->testimonial, 25, ' ...') }}</h3>
                            @if ($left_side_testimonial->video_link)
                                <a class="btn-theme popup-youtube" href="{{ $left_side_testimonial->video_link }}"><i class="fa fa-play-circle" style="font-family: FontAwesome, Bangla304, sans-serif;"></i> {{ __('Play Video') }}</a>
                            @endif
                            <div class="review-ratings">
                                {!! ratingShowDark($left_side_testimonial->rating) !!}
                                <a class="ratings-count" href="#">({{ $left_side_testimonial->rating }} {{ __('Ratings') }})</a>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="@if (isset($left_side_testimonial)) col-lg-7 @else col-lg-12 @endif">
                        <div class="inner-title mt-25">
                            <h2>{{ clean($testimonial_setting ? $testimonial_setting->title : '') }}</h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide owl-carousel owl-theme owl-navst st-three">
                            @foreach ($testimonials as $testimonial)
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        {!! imageShow($testimonial->image, __('Reviewer Photo')) !!}
                                    </div>
                                    <div class="content">
                                        <h5>{{ clean($testimonial ? $testimonial->name : '') }} <small>-
                                                {{ clean($testimonial ? $testimonial->designation : '') }}</small></h5>
                                        {!! ratingShow($testimonial->rating) !!}
                                        <p><i class="fa fa-quote-left"></i>
                                            {{ clean($testimonial ? $testimonial->testimonial : '') }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    @endif


    @if ($promotional_setting)
        <!-- App Section Start -->
        <section class="app-section over-layer-white pt-80 pb-90" style="@if (!empty($promotional_setting->bg_img))background-image: url({{ $promotional_setting->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif">
            <div class="container">
                <div class="row">
                    <div class="col-lg-10 offset-lg-1">
                        <div class="inner-title title-center">
                            <h2>{{ clean($promotional_setting ? $promotional_setting->title : '') }}</h2>
                            <h3>{{ clean($promotional_setting ? $promotional_setting->sub_title : '') }}</h3>
                            <div class="sec-line line-center"></div>
                        </div>
                        <p>{{ clean($promotional_setting ? $promotional_setting->description : '') }}</p>
                        <a class="btn-theme"
                            href="{{ clean($promotional_setting ? $promotional_setting->btn_1_url : '') }}">{{ clean($promotional_setting ? $promotional_setting->btn_1 : '') }}</a>
                        <a class="btn-theme btn-two"
                            href="{{ clean($promotional_setting ? $promotional_setting->btn_2_url : '') }}">{{ clean($promotional_setting ? $promotional_setting->btn_2 : '') }}</a>
                    </div>
                </div>
            </div>
        </section>
        <!-- App Section End -->
    @endif

    @if ($blog_setting)
        <!-- Blog Section Start -->
        <section class="blog-section bg-f8 pt-85 pb-55">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4>{{ clean($blog_setting ? $blog_setting->title : '') }}</h4>
                        <h2>{{ clean($blog_setting ? $blog_setting->sub_title : '') }}</h2>
                        <p>{{ clean($blog_setting ? $blog_setting->description : '') }}</p>
                    </div>
                </div>
                <div class="row">
                    @foreach ($blogs as $blog)
                        <div class="col-md-6 col-lg-4">
                            <div class="blog-post">
                                <div class="thumb">
                                    <a href="{{ route('view-single-blog-page', ['slug' => $blog->slug]) }}">
                                        {!! imageShow($blog->feature_img, __('Blog Image')) !!}
                                    </a>
                                    <div class="content">
                                        <a href="{{ route('view-single-blog-page', ['slug' => $blog->slug]) }}">
                                            <h3>{{ $blog ? $blog->title : '' }}</h3>
                                        </a>
                                        <div class="meta-box">
                                            <div class="admin-post"> {{ (isset($blog->userId)) ? $blog->userId->name : '' }} </div>
                                            <div class="inner">
                                                <div class="date">
                                                    <i class="fa fa-calendar-plus-o"></i>
                                                    {{ date('M', strtotime($blog->created_at)) }}
                                                    <b>{{ date('d', strtotime($blog->created_at)) }}</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <a href="{{ route('view-single-blog-page', ['slug' => $blog->slug]) }}"
                                    class="read-btn">{{ __('Continue Reading') }}
                                    <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- Blog Section End -->
    @endif

    @if (($spacial_package_setting && count($spacial_packages)) || ($place_setting && count($places)))
        @include('frontend.pages.packages.map-image-modal')
    @endif


@endsection

@section('page-script')
    @if ($hotel_setting)
        @include('frontend.scripts.map-script')
    @endif
    @if (($spacial_package_setting && count($spacial_packages)) || ($place_setting && count($places)))
        @include('frontend.scripts.package-map-script')
    @endif
@endsection
