<?php

use App\Actions\Fortify\UpdateUserPassword;
use App\Http\Controllers\AdminControllers\AdminAccommodationController;
use App\Http\Controllers\AdminControllers\AdminController;
use App\Http\Controllers\AdminControllers\AdminBlogCategoryController;
use App\Http\Controllers\AdminControllers\AdminBlogController;
use App\Http\Controllers\AdminControllers\AdminServiceController;
use App\Http\Controllers\AdminControllers\AdminSliderController;
use App\Http\Controllers\AdminControllers\AdminPartnerController;
use App\Http\Controllers\AdminControllers\AdminTagController;
use App\Http\Controllers\AdminControllers\AppSettingsController;
use App\Http\Controllers\AdminControllers\PageSettingsController;
use App\Http\Controllers\AdminControllers\TestimonialController;
use App\Http\Controllers\AdminControllers\AdminTeamController;
use App\Http\Controllers\AdminControllers\AdminDesignationController;
use App\Http\Controllers\AdminControllers\AdminFaqController;
use App\Http\Controllers\AdminControllers\DynamicPageController;
use App\Http\Controllers\AdminControllers\AdminEventController;
use App\Http\Controllers\AdminControllers\AdminFacilityController;
use App\Http\Controllers\AdminControllers\AdminGalleryController;
use App\Http\Controllers\AdminControllers\AdminPaymentController;
use App\Http\Controllers\AdminControllers\AdminHotelsController;
use App\Http\Controllers\AdminControllers\AdminPlaceController;
use App\Http\Controllers\AdminControllers\AdminHotelImageController;
use App\Http\Controllers\AdminControllers\AdminCountryController;
use App\Http\Controllers\AdminControllers\AdminCityController;
use App\Http\Controllers\AdminControllers\AdminHotelAccommodationController;
use App\Http\Controllers\AdminControllers\AdminPackageController;
use App\Http\Controllers\AdminControllers\AdminPackageCategoryController;
use App\Http\Controllers\AdminControllers\AdminPackageImagesController;
use App\Http\Controllers\AdminControllers\AdminPackageSubPriceController;
use App\Http\Controllers\AdminControllers\AdminPackageDepartureController;
use App\Http\Controllers\AdminControllers\AdminDiscountController;
use App\Http\Controllers\AdminControllers\AdminDiscountSubController;
use App\Http\Controllers\AdminControllers\AdminHotelBookingController;
use App\Http\Controllers\AdminControllers\AdminPackageBookingController;
use App\Http\Controllers\AdminControllers\AdminFeatureController;
use App\Http\Controllers\AdminControllers\AdminOauthSetting;
use App\Http\Controllers\AdminControllers\CommentController;
use App\Http\Controllers\AdminControllers\UserController;
use App\Http\Controllers\MenuSettings\MenuCategoryController;
use App\Http\Controllers\MenuSettings\MenuItemController;
use Illuminate\Support\Facades\Route;


Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => ['admin']], function () {

    Route::get('/dashboard', [AdminController::class, 'index'])->name('dashboard');
    // profile routs
    Route::get('/profile', [AdminController::class, 'profile'])->name('profile');
    Route::post('/profile', [AdminController::class, 'profileUpdate'])->name('profile-update');
    Route::post('/password-update', [UpdateUserPassword::class, 'updateAdminPassword'])->name('password-update');
    Route::post('/delete-account', [AdminController::class, 'adminDelete'])->name('delete-account');
    Route::get('destory-image', [AdminController::class, 'destoryImage'])->name('destory.image');


    Route::middleware(['permission:contact'])->group(function () {
        Route::get('/contact-us', [AdminController::class, 'getContactMessage'])->name('contact.index');
        Route::get('/contact-view/{id}', [AdminController::class, 'viewContactMessage'])->name('contact.view');
        Route::delete('/contact/{id}', [AdminController::class, 'destroyContactMessage'])->name('contact.destroy');
    });


    Route::prefix('user')->as('user.')->middleware(['role:admin'])->group(function () {
        //role
        Route::prefix('role')->as('role.')->group(function () {
            Route::get('/', [UserController::class, 'roleIndex'])->name('index');
            Route::get('/create', [UserController::class, 'roleCreate'])->name('create');
            Route::post('/', [UserController::class, 'roleStore'])->name('store');
            Route::get('/edit/{role}', [UserController::class, 'roleEdit'])->name('edit');
            Route::post('/edit/{role}', [UserController::class, 'getRolePermission']);
            Route::put('/update/{role}', [UserController::class, 'roleUpdate'])->name('update');
            Route::delete('/destroy/{role}', [UserController::class, 'roleDestroy'])->name('destroy');
        });

        Route::prefix('client')->as('client.')->group(function () {
            Route::get('/', [UserController::class, 'clientIndex'])->name('index');
        });
    });

    Route::middleware(['role:admin'])->group(function () {
        Route::get('/comments', [CommentController::class, 'index'])->name('comment.index');
    });


    Route::prefix('settings')->as('settings.')->middleware(['permission:settings'])->group(function () {

        Route::any('/google-login', [AdminOauthSetting::class, 'getGoogleLoginSettings'])->name('google.login');
        Route::any('/facebook-login', [AdminOauthSetting::class, 'getFacebookSettings'])->name('facebook.login');

        Route::get('general', [AppSettingsController::class, 'getGeneralSettings'])->name('general');
        Route::post('general', [AppSettingsController::class, 'saveGeneralSettings'])->name('general-save');


        Route::get('/top-header', [AppSettingsController::class, 'topHeaderIndex'])->name('topHeader.index');
        Route::post('/top-header-store', [AppSettingsController::class, 'topHeaderStore'])->name('topHeader.store');


        Route::get('/footer', [AppSettingsController::class, 'footerIndex'])->name('footer.index');
        Route::post('/store-footer', [AppSettingsController::class, 'storeFooter'])->name('footer.store');


        Route::get('logo-favicon', [AppSettingsController::class, 'getLogoFaviconSettings'])->name('logo-favicon');
        Route::post('logo-favicon', [AppSettingsController::class, 'saveLogoFaviconSettings'])->name('logo-favicon-save');


        Route::get('seo', [AppSettingsController::class, 'getSeoSettings'])->name('seo');
        Route::post('seo', [AppSettingsController::class, 'saveSeoSettings'])->name('seo-save');


        Route::get('smtp', [AppSettingsController::class, 'getSmtpSettings'])->name('smtp');
        Route::post('smtp', [AppSettingsController::class, 'saveSmtpSettings'])->name('smtp-save');


        Route::get('insert-header-footer', [AppSettingsController::class, 'getInsertHeaderFooterSettings'])->name('insert-header-footer');
        Route::post('insert-header-footer', [AppSettingsController::class, 'saveInsertHeaderFooterSettings'])->name('insert-header-footer-save');

        Route::get('social-media', [AppSettingsController::class, 'socialMediaSettings'])->name('social-media');
        Route::post('social-media-save', [AppSettingsController::class, 'saveSocialMediaSettings'])->name('social-media-save');
    });


    Route::prefix('settings/menu')->as('menu.')->middleware(['permission:settings'])->group(function () {
        Route::resource('/category', MenuCategoryController::class, ['only' => ['index', 'store', 'edit', 'update', 'destroy']]);
        Route::resource('/item', MenuItemController::class, ['only' => ['index', 'store']]);
        Route::post('/item/order/store/menu', [MenuItemController::class, 'storeMenu'])->name('item.store.menu');
        Route::post('/item/order/store', [MenuItemController::class, 'orderStore'])->name('item.orderStore');
        Route::post('/item/status/store', [MenuItemController::class, 'menuStatus'])->name('item.menuStatus');
        Route::post('/item/delete', [MenuItemController::class, 'deleteMenu'])->name('item.delete');
    });


    Route::prefix('page-settings')->as('page-settings.')->middleware(['permission:page_settings'])->group(function () {

        Route::get('/home', [PageSettingsController::class, 'homeIndex'])->name('home-page.index');

        Route::get('/contact-page', [PageSettingsController::class, 'contactIndex'])->name('contact-page.index');

        Route::get('/about-page', [PageSettingsController::class, 'aboutIndex'])->name('about-page.index');

        Route::get('/services-page', [PageSettingsController::class, 'servicesIndex'])->name('services-page.index');

        Route::get('/hotel-page', [PageSettingsController::class, 'hotelIndex'])->name('hotel-page.index');

        Route::get('/blogs-page', [PageSettingsController::class, 'blogsIndex'])->name('blogs-page.index');

        Route::get('/teams-page', [PageSettingsController::class, 'teamsIndex'])->name('teams-page.index');

        Route::get('/faq-page', [PageSettingsController::class, 'faqIndex'])->name('faq-page.index');

        Route::get('/packages', [PageSettingsController::class, 'eventIndex'])->name('packages.index');

        Route::get('/places', [PageSettingsController::class, 'galleryIndex'])->name('gallery.index');

        Route::get('/auth-pages', [PageSettingsController::class, 'authIndex'])->name('auth-page.index');

        Route::get('/client-dashboard-page', [PageSettingsController::class, 'clientDashboardPageIndex'])->name('client-dashboard-page.index');

        Route::post('/seo', [PageSettingsController::class, 'seoSettings'])->name('page.seo');

        Route::get('/input-fields', [PageSettingsController::class, 'inputFields'])->name('input-fields');

        Route::post('/store-page', [PageSettingsController::class, 'store'])->name('contact-page.store');

        Route::post('/store-page-img', [PageSettingsController::class, 'storeWithImg'])->name('contact-page.store-img');


        Route::get('error-page', [PageSettingsController::class, 'errorPageSettings'])->name('error.page');
    });


    Route::prefix('testimonial')->as('testimonial.')->middleware(['permission:testimonial'])->group(function () {
        Route::get('/', [TestimonialController::class, 'index'])->name('index');
        Route::get('/form', [TestimonialController::class, 'form'])->name('form');
        Route::post('/store', [TestimonialController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [TestimonialController::class, 'edit'])->name('edit');
        Route::get('/show/{id}', [TestimonialController::class, 'show'])->name('show');
        Route::post('/update/{id}', [TestimonialController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [TestimonialController::class, 'delete'])->name('delete');
    });


    Route::resource('/slider', AdminSliderController::class)->middleware(['permission:slider_settings']);


    Route::prefix('feature')->as('feature.')->group(function () {
        Route::get('/', [AdminFeatureController::class, 'index'])->name('index');
        Route::get('/form', [AdminFeatureController::class, 'create'])->name('form');
        Route::post('/store', [AdminFeatureController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [AdminFeatureController::class, 'edit'])->name('edit');
        Route::patch('/update/{id}', [AdminFeatureController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [AdminFeatureController::class, 'delete'])->name('delete');
    });




    Route::resource('/partner', AdminPartnerController::class)->middleware(['permission:partner']);
    Route::get('/partner/show/{id}', [AdminPartnerController::class, 'partnerShow'])->middleware(['permission:partner']);


    Route::resource('/designation', AdminDesignationController::class)->middleware(['permission:designation']);


    Route::resource('/team', AdminTeamController::class)->middleware(['permission:attorney']);
    Route::get('/team/show/{id}', [AdminTeamController::class, 'teamShow'])->middleware(['permission:attorney']);


    Route::resource('/faq', AdminFaqController::class)->middleware(['permission:faq']);


    Route::prefix('blog')->as('blog.')->middleware(['permission:blog'])->group(function () {
        Route::resource('/tag', AdminTagController::class);
        Route::resource('/category', AdminBlogCategoryController::class);
        Route::resource('/weblog', AdminBlogController::class);
        Route::get('/weblog/featured/{id}', [AdminBlogController::class, 'makeFeatured']);
        Route::get('/comment-settings', [AdminBlogController::class, 'commentSettingsIndex'])->name('comment-settings');
        Route::post('/comment-settings', [AdminBlogController::class, 'commentSettingsStore'])->name('comment-settings');
    });


    Route::prefix('dynamic-page')->as('dynamic-page.')->middleware(['permission:dynamic_page'])->group(function () {
        Route::get('/page-index/{slug?}', [DynamicPageController::class, 'index'])->name('page-index');
        Route::post('/page-store/{slug?}', [DynamicPageController::class, 'store'])->name('page-store');
        Route::get('/destroy-page/{slug?}', [DynamicPageController::class, 'pageDestroy'])->name('destroy-page');
    });


    Route::prefix('event')->as('event.')->group(function () {
        Route::get('/', [AdminEventController::class, 'index'])->name('index');
        Route::get('/create', [AdminEventController::class, 'create'])->name('create');
        Route::post('/store', [AdminEventController::class, 'store'])->name('store');
        Route::get('edit/{id}', [AdminEventController::class, 'edit'])->name('edit');
        Route::patch('/update/{id}', [AdminEventController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [AdminEventController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('gallery')->as('gallery.')->group(function () {
        Route::get('/', [AdminGalleryController::class, 'index'])->name('index');
        Route::get('/create', [AdminGalleryController::class, 'create'])->name('create');
        Route::post('/store', [AdminGalleryController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [AdminGalleryController::class, 'edit'])->name('edit');
        Route::patch('/update/{id}', [AdminGalleryController::class, 'update'])->name('update');
        Route::delete('/destroy//{id}', [AdminGalleryController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('newsletter')->as('newsletter.')->group(function () {
        Route::get('/', [AdminController::class, 'newsLetter'])->name('index');
        Route::delete('/destroy/{id}', [AdminController::class, 'newsLetterDestroy'])->name('destroy');
    });

    Route::prefix('payment-method')->as('payment.')->group(function () {
        Route::get('/', [AdminPaymentController::class, 'payment'])->name('index');
        Route::get('/from', [AdminPaymentController::class, 'paymentFrom'])->name('from');
        Route::get('/edit/{id}', [AdminPaymentController::class, 'paymentEdit'])->name('edit');
        Route::post('/status-update', [AdminPaymentController::class, 'paymentStatusUpdate'])->name('status.update');
        Route::post('/default-update', [AdminPaymentController::class, 'paymentDefaultUpdate'])->name('default.update');
        Route::post('/update/{id}', [AdminPaymentController::class, 'paymentUpdate'])->name('update');
        Route::delete('/destroy/{id}', [AdminPaymentController::class, 'paymentDestroy'])->name('destroy');
    });


    Route::resource('/facility', AdminFacilityController::class);
    Route::get('/facility/show/{id}', [AdminFacilityController::class, 'facilityShow'])->name('facility.show');
    Route::resource('/accommodation', AdminAccommodationController::class);

    //for hotels
    Route::prefix('hotels')->as('hotel.')->group(function () {
        Route::get('/', [AdminHotelsController::class, 'index'])->name('index');
        Route::get('/create', [AdminHotelsController::class, 'create'])->name('create');
        Route::post('/store', [AdminHotelsController::class, 'store'])->name('store');
        Route::patch('/update/{id}', [AdminHotelsController::class, 'update'])->name('update');
        Route::get('/show/{id}', [AdminHotelsController::class, 'show'])->name('show');
        Route::get('/edit/{id}', [AdminHotelsController::class, 'edit'])->name('edit');
        Route::delete('/destroy/{id}', [AdminHotelsController::class, 'destroy'])->name('destroy');
    });
    Route::prefix('hotel-image')->as('hotel.image.')->group(function () {
        Route::get('/', [AdminHotelImageController::class, 'index'])->name('index');
        Route::get('/show/{id}', [AdminHotelImageController::class, 'show'])->name('show');
        Route::get('/create', [AdminHotelImageController::class, 'create'])->name('create');
        Route::post('/store', [AdminHotelImageController::class, 'store'])->name('store');
        Route::patch('/update/{id}', [AdminHotelImageController::class, 'update'])->name('update');
        Route::get('/edit/{id}', [AdminHotelImageController::class, 'edit'])->name('edit');
        Route::delete('/destroy/{id}', [AdminHotelImageController::class, 'destroy'])->name('destroy');
    });


    Route::resource('hotel-accommodation', AdminHotelAccommodationController::class);
    Route::get('hotel-accommodation/{hotel_id}/add', [AdminHotelAccommodationController::class, 'accommodationAdd'])->name('hotel-accommodation.add');
    Route::post('hotel-accommodation/image/destroy', [AdminHotelAccommodationController::class, 'imageDestroy'])->name('hotel-accommodation.image.destroy');

    Route::prefix('booking')->as('booking.')->group(function () {
        Route::resource('/hotel', AdminHotelBookingController::class);
        Route::resource('/package', AdminPackageBookingController::class);
    });


    Route::prefix('country')->as('country.')->group(function () {
        Route::get('/', [AdminCountryController::class, 'index'])->name('index');
        Route::get('/create', [AdminCountryController::class, 'create'])->name('create');
        Route::post('/store', [AdminCountryController::class, 'store'])->name('store');
        Route::delete('/destroy/{id}', [AdminCountryController::class, 'destroy'])->name('destroy');
    });
    Route::prefix('city')->as('city.')->group(function () {
        Route::get('/', [AdminCityController::class, 'index'])->name('index');
        Route::get('/create', [AdminCityController::class, 'create'])->name('create');
        Route::post('/store', [AdminCityController::class, 'store'])->name('store');
        Route::delete('/destroy/{id}', [AdminCityController::class, 'destroy'])->name('destroy');
    });
    Route::prefix('place')->as('place.')->group(function () {
        Route::get('/', [AdminPlaceController::class, 'index'])->name('index');
        Route::get('/create', [AdminPlaceController::class, 'create'])->name('create');
        Route::post('/store', [AdminPlaceController::class, 'store'])->name('store');
        Route::patch('/update/{id}', [AdminPlaceController::class, 'update'])->name('update');
        Route::get('/edit/{id}', [AdminPlaceController::class, 'edit'])->name('edit');
        Route::post('/destroy/{id}', [AdminPlaceController::class, 'destroy'])->name('destroy');
    });

    Route::resource('/packages', AdminPackageController::class);

    Route::resource('/package-category', AdminPackageCategoryController::class);
    Route::resource('/package-image', AdminPackageImagesController::class);
    Route::get('/package-subprice/package/{package_id}/edit', [AdminPackageSubPriceController::class, 'packageSubPriceEdit'])->name('package-subprice.package');
    Route::put('/package-subprice/package/update/{package_id}', [AdminPackageSubPriceController::class, 'packageSubPriceupdate'])->name('package-subprice.package.update');
    Route::resource('/package-subprice', AdminPackageSubPriceController::class);
    Route::resource('/package-departure', AdminPackageDepartureController::class);
    Route::get('/package-departure/package/{package_id}/add', [AdminPackageDepartureController::class, 'packageDepartureAdd'])->name('package-departure.package.add');

    Route::resource('/discounts', AdminDiscountController::class);
    Route::resource('/discount-group', AdminDiscountSubController::class);
});
