<?php



use App\Http\Controllers\GuestViewControllers\GuestBookingController;
use App\Http\Controllers\GuestViewControllers\GuestCommentController;
use App\Http\Controllers\GuestViewControllers\GuestViewController;

use Illuminate\Support\Facades\Route;



Route::get('/optimize', function (){
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
    echo 'done';
    return redirect()->route('home');
});
Route::get('/storage-link', function (){
    \Illuminate\Support\Facades\Artisan::call('storage:link');
    echo 'done';
    return redirect()->route('home');
});


require __DIR__ . '/auth.php';
require __DIR__ . '/admin.php';
require __DIR__ . '/guest.php';


Route::get('/', [GuestViewController::class, 'index'])->name('home');

Route::get('/contact', [GuestViewController::class, 'contact'])->name('contact');
Route::post('/contact-store', [GuestViewController::class, 'storeContactMessage'])->name('store-contact');

Route::get('/blog', [GuestViewController::class, 'blog'])->name('blog');
Route::get('/blog/{slug}', [GuestViewController::class, 'viewSingleBlogPage'])->name('view-single-blog-page');
Route::get('blog-category/{id}', [GuestViewController::class, 'blogCategory'])->name('blog-category');
Route::get('blog-tag/{id}', [GuestViewController::class, 'blogTag'])->name('blog-tag');
Route::get('search-blog', [GuestViewController::class, 'searchBlog'])->name('search-blog');


Route::get('/about-us', [GuestViewController::class, 'aboutUs'])->name('about-us');

Route::get('/team', [GuestViewController::class, 'team'])->name('team');
Route::get('/single-team/{id}', [GuestViewController::class, 'singleTeam'])->name('single-team');

Route::get('/testimonial', [GuestViewController::class, 'testimonial'])->name('testimonial');

Route::get('/hotel', [GuestViewController::class, 'hotel'])->name('hotel');
Route::get('/single-hotel/{id}', [GuestViewController::class, 'singleHotel'])->name('single-hotel');
Route::get('/hotel-accommodation-image/{id}', [GuestViewController::class, 'hotelAccommodationImage'])->name('hotel-accommodation-image');

Route::get('/booking-hotel/{hotel_id}/accommodation/{accommodation_id}', [GuestBookingController::class, 'bookingHotel'])->name('booking.hotel');
Route::post('/booking-hotel/save', [GuestBookingController::class, 'bookingHotelSave'])->name('booking.hotel.save');


Route::get('/booking-package/{package_id}/group/{group_id}', [GuestBookingController::class, 'bookingPackage'])->name('booking.package');
Route::post('/booking-package/save', [GuestBookingController::class, 'bookingPackageSave'])->name('booking.package.save');
Route::get('/confirm-booking', [GuestBookingController::class, 'confrimBooking'])->name('confirm.booking');


Route::get('/discount/{discount_id}', [GuestViewController::class, 'discountPage'])->name('discount.details');

Route::get('/shop', [GuestViewController::class, 'shop'])->name('shop');

Route::get('/faq', [GuestViewController::class, 'faq'])->name('faq');


Route::get('/places', [GuestViewController::class, 'places'])->name('places');


Route::get('/place/{id}', [GuestViewController::class, 'package'])->name('place');
Route::get('/package/{type_id?}/{type?}', [GuestViewController::class, 'package'])->name('package');
Route::get('/package-details/{package_id}', [GuestViewController::class, 'packageDetails'])->name('package.details');

Route::post('/news-letter', [GuestViewController::class, 'newsNetter'])->name('news-letter');


Route::post('/comment', [GuestCommentController::class, 'store'])->name('guest.comment.store');



