<?php if($packages->count()): ?>
    <div class="row grid-mb">
        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $discount = $package->discount ? $package->discount->discount : null;

                $group_size = 0;
                $subprices = $package->subprice;
                if ($subprices) {
                    $group_size = $subprices->max('group_size');
                }

                $package_images = $package->images;
                $route = route('package.details', $package->id);
            ?>
            <div class="col-xl-6 col-lg-6 col-md-6">
                <div class="special-packages">
                    <div class="thumb">
                        <?php if(count($package_images)): ?>
                        <a href="<?php echo e($route); ?>">
                            <?php echo imageShow($package_images[0]->images, __('Tour Image'), ''); ?>

                        </a>
                        <?php endif; ?>

                        <?php if($discount): ?>
                            <div class="offer-price"> <?php echo e(__('Off')); ?>

                                <?php echo e(discountPriceShow($discount)); ?>

                            </div>
                        <?php endif; ?>
                        <div class="post-title-box">
                            <div class="price-box">
                                <h5><?php echo e(currencyFormat($package->price)); ?>

                                </h5>
                                <h6><?php echo e(__('Starts From')); ?></h6>
                            </div>
                            <div class="title-box">
                                <a href="<?php echo e($route); ?>">
                                    <h4><?php echo e(Str::limit(clean($package?$package->title:'', 50))); ?></h4>
                                </a>
                                <h3><?php echo e(clean($package?$package->location:'')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="content">
                        <ul class="info">
                            <li><a href="#"><i class="fa fa-calendar"></i><?php echo e($package->day); ?>

                                    <?php echo e(__('Days')); ?></a></li>
                            <li><a href="#"><i
                                        class="fa fa-user"></i><?php echo e($group_size); ?></a>
                            </li>
                            <?php if($package->tour_map_image): ?>
                                <li><a class="package_map" href="#package_map_modal" data-toggle="modal"
                                        data-name="<?php echo e($package->title); ?>"
                                        data-image="<?php echo e(imageShow($package->tour_map_image, 'Package Image')); ?>"><i
                                            class="fa fa-map-marker"></i><?php echo e(__('View Map Image')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                        <p><?php echo e(clean(Str::limit($package->description,150))); ?></p>
                        <div class="small-hotel">
                            <div class="thumb">
                                <?php if(count($package_images)): ?>
                                    <?php $__currentLoopData = $package_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo imageShow($image->images, __('Tour Image'), ''); ?>&nbsp;
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <h5 class="share-btn"><i class="fa fa-share-alt" data-toggle="dropdown"
                                aria-expanded="false"></i>
                            <div class="dropdown-menu">
                                <?php echo $__env->make('frontend.share-link',['route'=>$route], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </h5>
                        <a class="btn-theme"
                            href="<?php echo e($route); ?>"><?php echo e(__('View Details')); ?></a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="row">
        <div class="col-md-12">
            <?php if($packages instanceof \Illuminate\Pagination\LengthAwarePaginator): ?>
                <?php echo e($packages->render('frontend.pagination.index', ['place_id' => $place_id, 'category_id' => $category_id, 'min_price' => $min_price, 'max_price' => $max_price])); ?>

            <?php endif; ?>
        </div>
    </div>
<?php else: ?>
    <div class="alert alert-warning text-center">
        <i class="fa fa-search fa-5x mb-3" aria-hidden="true"></i>
        <h4><?php echo e(__('No hotel found')); ?></h4>
    </div>
<?php endif; ?>
<?php /**PATH /home/www/bdctravel.bdcoder.com/resources/views/frontend/pages/packages/list.blade.php ENDPATH**/ ?>