
<?php $__env->startSection('title', config('app.name', 'laravel').' | '.$title); ?>
<?php $__env->startSection('page-css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.slider.index')); ?>"><?php echo e(__('Slider')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo e(__($title)); ?></h6>
                    </div>
                    <form action="<?php echo e($slider? route('admin.slider.update',$slider->id) : route('admin.slider.store')); ?>"
                          method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($slider): ?>
                            <?php echo method_field('PATCH'); ?>
                        <?php endif; ?>
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-8">
                                    <p class="mb-1 font-weight-bold"><?php echo e(__('Title :')); ?> </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="title" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="<?php echo e(__('Slider title')); ?>"
                                               value="<?php echo e($slider?$slider->title:old('title')); ?>">
                                        <br>
                                        <?php if($errors->has('title')): ?>
                                            <span class="text-danger"><?php echo e($errors->first('title')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <p class="mb-1 font-weight-bold"><?php echo e(__('Subtitle :')); ?> </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="sub_title" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="<?php echo e(__('Slider sub_title')); ?>"
                                               value="<?php echo e($slider?$slider->sub_title:old('sub_title')); ?>">
                                        <br>
                                        <?php if($errors->has('subtitle')): ?>
                                            <span class="text-danger"><?php echo e($errors->first('subtitle')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <p class="mb-1 font-weight-bold"><?php echo e(__('Button Name :')); ?> </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="button_name" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="<?php echo e(__('Slider button name')); ?>"
                                               value="<?php echo e($slider?$slider->button_name:old('button_name')); ?>">
                                        <br>
                                        <?php if($errors->has('button_name')): ?>
                                            <span class="text-danger"><?php echo e($errors->first('button_name')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <p class="mb-1 font-weight-bold"><?php echo e(__('Button Url :')); ?> </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="text" name="button_url" class="form-control" aria-label="Large"
                                               aria-describedby="inputGroup-sizing-sm"
                                               placeholder="<?php echo e(__('Slider button url')); ?>"
                                               value="<?php echo e($slider?$slider->button_url:old('button_url')); ?>">
                                        <br>
                                        <?php if($errors->has('button_url')): ?>
                                            <span class="text-danger"><?php echo e($errors->first('button_url')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <p class="mb-1 font-weight-bold"><?php echo e(__('Description :')); ?> </p>
                                    <div class="input-group mb-3">
                                        <textarea class="form-control" name="description" aria-label="With textarea"
                                                  rows="5"
                                                  placeholder="<?php echo e(__('Write description here...')); ?>"><?php echo clean($slider?$slider->description:old('description')); ?></textarea>
                                    </div>
                                </div>
                                <div class="col-md-4">

                                    <table class="table table-responsive-sm">
                                        <tbody>
                                        <tr>
                                            <td class="pl-3">
                                                <label for="programStatus">
                                                    <span class="font-weight-bold"><?php echo e(__('Publish Status')); ?></span>
                                                </label>
                                            </td>
                                            <td>
                                                <label class="switch float-left">
                                                    <input type="checkbox" name="status"
                                                           <?php echo e($slider?($slider->status==true?'checked':''):''); ?> id="programStatus">
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                    <div class="pl-3 pr-2">
                                        <p class="mb-2 font-weight-bold"><?php echo e(__('Background Image : ')); ?><br><code><?php echo e(__('Acceptable image
                                           size 1920 x 1200 pixel')); ?></code></p>
                                        <div class="mb-3">
                                            <div class="slider_bg_image" id="slider_bg_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($slider): ?>
                                        <div class="pl-3 pr-2 ">
                                            <?php echo imageShow($slider->bg_image, 'slider image', 'img-thumbnail bg-secondary', '', 'App\Models\Blog', $slider->id, 'bg_image'); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit"><?php echo e(__('Submit form')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('backend.pages.sliders.internal-assets.js.slider-page-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/sliders/form.blade.php ENDPATH**/ ?>