

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('frontend/nouislider/dist/nouislider.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" data-type="parallax" data-speed="3" style="<?php if(!empty($pageContent->bg_img)): ?>background-image: url(<?php echo e($pageContent->bg_img); ?>);<?php else: ?> background-image: url(<?php echo e(asset('frontend/images/bg/px-1.jpg')); ?>); <?php endif; ?>">

        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(isset($title) ? $title : ''); ?></h4>
                        <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a>
                            <a><?php echo e(isset($title) ? $title : ''); ?></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Latest Hotel Section Start -->
    <section class="special-packages-sec pt-4 pb-60">
        <div class="container">
            <div class="list-size">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="card mb-4">
                            <div class="card-header bg-white p-2 px-3">
                                <h6 class="modal-title text-bold"><?php echo e(__('Search')); ?></h6>
                            </div>
                            <div class="card-body p-2 px-3">
                                <form id="data_form" method="GET">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="page" id="page" value="1">

                                    <div class="form-group">
                                        <label for="" class="mb-1"><?php echo e(__('Country')); ?></label>
                                        <select name="country_id" class="form-control">
                                            <option value=""><?php echo e(__('Select')); ?></option>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    <?php echo e(!empty($country_id) && $country_id == $country->id ? 'selected' : ''); ?>

                                                    value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="" class="mb-1"><?php echo e(__('City')); ?></label>
                                        <select name="city_id" class="form-control" id="city_html">
                                            <?php echo $city_html; ?>

                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="" class="mb-1"><?php echo e(__('Person')); ?></label>
                                        <div class="input-group">
                                            <select name="adult" id="" class="form-control">
                                                <option value=""><?php echo e(__('Adult')); ?></option>
                                                <?php for($ai = 1; $ai <= 4; $ai++): ?>
                                                    <option <?php echo e(!empty($adult_person) && $adult_person == $ai ? 'selected' : ''); ?> value="<?php echo e($ai); ?>"><?php echo e($ai); ?></option>
                                                <?php endfor; ?>
                                            </select>
                                            <select name="children" id="" class="form-control">
                                                <option value=""><?php echo e(__('Children')); ?></option>
                                                <?php for($ci = 1; $ci <= 4; $ci++): ?>
                                                    <option <?php echo e(!empty($children_person) && $children_person == $ci ? 'selected' : ''); ?> value="<?php echo e($ci); ?>"><?php echo e($ci); ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for=""><?php echo e(__('Price')); ?></label>
                                        <div id="steps-slider" class="mt-1"></div>
                                        <input type="hidden" id="min_price" name="min_price" value="<?php echo e($min_price); ?>" />
                                        <input type="hidden" id="max_price" name="max_price" value="<?php echo e($max_price); ?>" />
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-9" id="data_html">
                        <?php echo $list_view; ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Latest Hotel Section End -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('frontend.pages.hotel.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.scripts.map-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/www/bdctravel.bdcoder.com/resources/views/frontend/pages/hotel/index.blade.php ENDPATH**/ ?>