<table id="example" class="table bapric_table table-striped table-bordered miw-500" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th width="50"><?php echo e(__('SL')); ?></th>
            <th><?php echo e(__('Accommodation')); ?></th>
            <th><?php echo e(__('Room Size')); ?></th>
            <th><?php echo e(__('No. of Room')); ?></th>
            <th><?php echo e(__('No. of Guest')); ?></th>
            <th><?php echo e(__('Facilities')); ?></th>
            <th><?php echo e(__('Price')); ?></th>
            <th><?php echo e(__('Is Smoking')); ?></th>
            <th width="10%"><?php echo e(__('Action')); ?></th>
        </tr>
    </thead>
    <tbody id="data_html">
        <?php $__currentLoopData = $hotel_accommodations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->index + 1); ?></td>
                <td><?php echo e($item->accommodation->name); ?></td>
                <td><?php echo e($item->room_size . ' ' . __('sqr. mt.')); ?></td>
                <td><?php echo e($item->no_of_room); ?></td>
                <td><?php echo e($item->no_of_adult . __('Adult')); ?>

                    <br>
                    <?php echo e($item->no_of_children . __('Children')); ?>

                </td>
                <td><?php echo e($item->facilities ? implodeFunc(', ', getFacilities($item->facilities)) : ''); ?></td>
                <td><?php echo e(currencyFormat($item->price)); ?></td>
                <td><?php echo e(statusActiveDeactive($item->is_smoking)); ?></td>
                <td>
                    <div class="d-flex">
                        <a href="<?php echo e(route('admin.hotel-accommodation.edit', $item->id)); ?>">
                            <button type="button" class="btn btn-sm btn btn-success m-1 blogCategoryEditBtn"
                                data-id="<?php echo e($item->id); ?>"><?php echo e(__('Edit')); ?></button>
                        </a>
                        <a href="javascript:void(0)" title="<?php echo e(__('Delete')); ?>" class="deleteItem">
                            <button type="button" class="btn btn-sm btn btn-danger m-1"><?php echo e(__('Delete')); ?></button>
                            <form action="<?php echo e(route('admin.hotel-accommodation.destroy', $item->id)); ?>" method="post"
                                class="deleteForm">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('delete'); ?>
                                <input type="hidden" name="_method" value="delete">
                            </form>
                        </a>
                    </div>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/hotel/hotel-accommodation/list.blade.php ENDPATH**/ ?>