<script type="text/javascript">
    (function($) {
        "use strict";
        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo e(route('admin.hotel-accommodation.index')); ?>",
                data: function(d) {
                    d.hotel_id = $('#hotel_list').val(),
                    d.search = $('input[type="search"]').val()
                }
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'accommodation',
                    name: 'accommodation',
                },
                {
                    data: 'room_size',
                    name: 'room_size',
                },
                {
                    data: 'no_of_room',
                    name: 'no_of_room',
                },
                {
                    data: 'no_of_guest',
                    name: 'no_of_guest',
                },
                {
                    data: 'facilities',
                    name: 'facilities',
                },
                {
                    data: 'price',
                    name: 'price',
                },
                {
                    data: 'is_smoking',
                    name: 'is_smoking',
                },
                {
                    data: 'action',
                    name: 'action',
                }
            ]
        });

        $(document.body).on('change', '#hotel_list', function() {
            table.draw();
        });

    })(jQuery);
</script>
<?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/hotel/hotel-accommodation/internal-assets/js/datatable.blade.php ENDPATH**/ ?>