<div class="col-12">
    <div class="card card-dark bg-dark py-1">
        <div class="card-body p-4">
            <div class="row">
                <div class="col-md-8">
                    <form action="<?php echo e(route('admin.password-update')); ?>" method="post" enctype="multipart/form-data" class="wma-form">
                        <?php echo csrf_field(); ?>
                        <div class="col-12">
                            <div class="row mt-3">
                                <div class="col-12">
                                    <p class="mb-1 font-weight-bold text-right"><label for="currentPassword"><?php echo e(__('Current Password')); ?>: </label> </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="password" name="current_password" id="currentPassword" class="form-control rounded text-right"
                                               aria-label="Large" aria-describedby="inputGroup-sizing-sm">
                                        <br>
                                        <?php if($errors->has('current_password')): ?>
                                            <span class="text-danger"><?php echo e($errors->first('current_password')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <p class="mb-1 font-weight-bold text-right"><label for="password"><?php echo e(__('New Password')); ?>:</label> </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="password" name="password" id="password" class="form-control rounded text-right"
                                               aria-label="Large" aria-describedby="inputGroup-sizing-sm">
                                        <br>
                                        <?php if($errors->has('password')): ?>
                                            <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <p class="mb-1 font-weight-bold text-right"><label for="passwordConfirmation"><?php echo e(__('Confirm Password')); ?>:</label> </p>
                                    <div class="input-group input-group-lg mb-3">
                                        <input type="password" name="password_confirmation" id="passwordConfirmation" class="form-control rounded text-right"
                                               aria-label="Large" aria-describedby="inputGroup-sizing-sm">
                                        <br>
                                        <?php if($errors->has('password_confirmation')): ?>
                                            <span class="text-danger"><?php echo e($errors->first('password_confirmation')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="float-left">
                                <button class="btn btn-wave-light rounded btn-danger btn-lg" type="submit"><?php echo e(__('Save')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-md-4 py-5 text-right">
                    <div class="h5"><?php echo e(__('Update Password')); ?></div>
                    <p class=""><?php echo e(__('Ensure your account is using a long, random password to stay secure.')); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/profile/update-password-form.blade.php ENDPATH**/ ?>